/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.view;

import clews.data.Association;
import clews.data.Class;
import clews.data.Specification;
import clews.gui.diagram.SpecificationDiagram;
import clews.gui.view.AssociationView;
import clews.gui.view.ClassView;
import clews.gui.view.SelectableObject;
import clews.gui.view.ViewObject;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;

public class SpecificationView
extends ViewObject {
    protected SpecificationDiagram diagram;
    protected ArrayList<ClassView> classes;
    protected ArrayList<AssociationView> assocs;
    protected Specification specification;

    public SpecificationView(Specification s) {
        this.specification = s;
        this.diagram = new SpecificationDiagram(this);
        this.classes = new ArrayList();
        this.assocs = new ArrayList();
        this.specification.setPath(null);
    }

    public SpecificationDiagram getDiagram() {
        return this.diagram;
    }

    public ArrayList<ClassView> getClasses() {
        return this.classes;
    }

    public ArrayList<AssociationView> getAssociations() {
        return this.assocs;
    }

    public void delete(ClassView cv) {
        ArrayList<Association> atodel = this.specification.delete(cv.getClassObject());
        for (Association a : atodel) {
            this.assocs.remove(a.getView());
        }
        this.classes.remove(cv);
        this.diagram.applyChanges();
    }

    public void delete(AssociationView av) {
        this.specification.delete(av.getAssociationObject());
        this.assocs.remove(av);
        this.diagram.applyChanges();
    }

    @Override
    public void draw(Graphics2D g) {
        ArrayList<SelectableObject> todraw = new ArrayList<SelectableObject>();
        g.setStroke(new BasicStroke(1.0f));
        for (AssociationView associationView : this.assocs) {
            if (associationView.isOver()) {
                todraw.add(associationView);
                continue;
            }
            associationView.draw(g);
        }
        for (ViewObject viewObject : todraw) {
            viewObject.draw(g);
        }
        todraw = new ArrayList();
        for (ClassView classView : this.classes) {
            if (classView.isOver()) {
                todraw.add(classView);
                continue;
            }
            classView.draw(g);
        }
        for (ViewObject viewObject : todraw) {
            viewObject.draw(g);
        }
    }

    public void applyChanges() {
        this.specification.applyChanges();
    }

    public ClassView addNewClassView(Class c) {
        ClassView cv = null;
        if (c != null) {
            cv = new ClassView(this, c);
            c.setView(cv);
            this.classes.add(cv);
        }
        return cv;
    }

    public AssociationView addNewAssociationView(Association a) {
        AssociationView av = null;
        if (a != null) {
            av = new AssociationView(this, a);
            a.setView(av);
            this.assocs.add(av);
        }
        return av;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public Rectangle getPrintBounds() {
        return null;
    }
}

