/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.view;

import clews.History;
import clews.MainFrame;
import clews.data.Link;
import clews.env.Environment;
import clews.gui.dialogs.EditLinkDialog;
import clews.gui.view.ConfigurationView;
import clews.gui.view.InstanceView;
import clews.gui.view.SelectableObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;

public class LinkView
extends SelectableObject {
    protected Link link;
    protected Color color;
    protected int cntleft;
    protected int cntright;
    protected Line2D.Double line;

    public LinkView(Link l) {
        this.link = l;
        this.cntleft = l.getLeft().getNumberOfLinks(l.getRight());
        this.cntright = l.getRight().getNumberOfLinks(l.getLeft());
        this.color = Environment.ASSOCIATION_COLOR;
        this.isEditable = true;
    }

    public Link getLink() {
        return this.link;
    }

    public void decreaseLeft() {
        --this.cntleft;
    }

    public void decreaseRight() {
        --this.cntright;
    }

    public int getLeftCnt() {
        return this.cntleft;
    }

    public int getRightCnt() {
        return this.cntright;
    }

    @Override
    public void mark() {
        this.color = Environment.MOUSE_OVER_ASSOCIATION_COLOR;
    }

    @Override
    public void unmark() {
        this.color = Environment.ASSOCIATION_COLOR;
    }

    @Override
    public boolean contains(Point2D mp) {
        return this.getLine().ptSegDist(mp) < Environment.ASSOCIATION_PICKING_SENSITVITY;
    }

    @Override
    public boolean setOver(boolean isOver) {
        Color save = this.color;
        this.color = isOver ? Environment.MOUSE_OVER_ASSOCIATION_COLOR : Environment.ASSOCIATION_COLOR;
        return save != this.color;
    }

    public Line2D getLine() {
        if (this.line == null || ((InstanceView)this.link.getLeft().getView()).hasPositionChanged() || ((InstanceView)this.link.getRight().getView()).hasPositionChanged()) {
            double r1 = ((InstanceView)this.link.getLeft().getView()).getRadius();
            double r2 = ((InstanceView)this.link.getRight().getView()).getRadius();
            InstanceView iv1 = (InstanceView)this.link.getLeft().getView();
            InstanceView iv2 = (InstanceView)this.link.getRight().getView();
            Point2D c1 = iv1.getCenter();
            Point2D c2 = iv2.getCenter();
            Point2D.Double dir = new Point2D.Double(-(c2.getY() - c1.getY()), c2.getX() - c1.getX());
            double dist = dir.distance(0.0, 0.0);
            Point2D.Double v1 = new Point2D.Double(((Point2D)dir).getX() / dist * r1, ((Point2D)dir).getY() / dist * r1);
            Point2D.Double v2 = new Point2D.Double(((Point2D)dir).getX() / dist * r2, ((Point2D)dir).getY() / dist * r2);
            this.line = new Line2D.Double(c1.getX() + ((Point2D)v1).getX() - 2.0 * ((Point2D)v1).getX() / (double)(this.link.getLeft().getNumberOfLinks(this.link.getRight()) + 1) * (double)this.cntleft, c1.getY() + ((Point2D)v1).getY() - 2.0 * ((Point2D)v1).getY() / (double)(this.link.getLeft().getNumberOfLinks(this.link.getRight()) + 1) * (double)this.cntleft, c2.getX() + ((Point2D)v2).getX() - 2.0 * ((Point2D)v2).getX() / (double)(this.link.getRight().getNumberOfLinks(this.link.getLeft()) + 1) * (double)this.cntright, c2.getY() + ((Point2D)v2).getY() - 2.0 * ((Point2D)v2).getY() / (double)(this.link.getRight().getNumberOfLinks(this.link.getLeft()) + 1) * (double)this.cntright);
            return this.line;
        }
        return this.line;
    }

    protected double getLineAngle(InstanceView cv1, InstanceView cv2) {
        double dx = cv2.getCenter().getX() - cv1.getCenter().getX();
        double dy = cv2.getCenter().getY() - cv1.getCenter().getY();
        double alpha = Math.acos(dx / Math.sqrt(dx * dx + dy * dy));
        if (dy < 0.0) {
            alpha = Math.PI * 2 - alpha;
        }
        return alpha;
    }

    protected double getLineLength() {
        Line2D l = this.getLine();
        return Math.sqrt(Math.pow(l.getX1() - l.getX2(), 2.0) + Math.pow(l.getY1() - l.getY2(), 2.0));
    }

    protected void drawName(Graphics2D g) {
        InstanceView iv1 = (InstanceView)this.link.getLeft().getView();
        InstanceView iv2 = (InstanceView)this.link.getRight().getView();
        double alpha = this.getLineAngle(iv1, iv2);
        Shape name = Environment.getStandardText(this.link.getDescription());
        AffineTransform save = g.getTransform();
        g.transform(AffineTransform.getTranslateInstance(iv1.getCenter().getX(), iv1.getCenter().getY() + 15.0));
        double shift = this.getLineLength() / 2.0 - (double)(name.getBounds().width / 2);
        g.rotate(alpha);
        if (alpha >= 1.5707963267948966 && alpha < 4.71238898038469) {
            g.rotate(Math.PI);
            g.translate(-shift - (double)name.getBounds().width, (double)(-name.getBounds().height - 17));
            boolean mul = true;
            boolean arrowShift = false;
        } else {
            g.translate(shift, (double)(-name.getBounds().height - 17));
            int arrowShift = name.getBounds().width;
            int mul = -1;
        }
        g.fill(name);
        g.setTransform(save);
    }

    @Override
    public void draw(Graphics2D g) {
        Composite ocomp = g.getComposite();
        if (Environment.IS_CONTROL_DOWN) {
            g.setComposite(AlphaComposite.getInstance(3, Environment.CLASS_SELECTION_ALPHA));
        }
        g.setColor(this.color);
        g.draw(this.getLine());
        if (this.link.getDescription() != null && this.link.getDescription().length() > 0) {
            this.drawName(g);
        }
        g.setComposite(ocomp);
    }

    @Override
    public void clicked(Point2D p) {
    }

    @Override
    public void release() {
    }

    @Override
    public void delete() {
        MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.DELETE, "Link deleted");
        ((ConfigurationView)this.link.getConfiguration().getView()).delete(this);
    }

    @Override
    public void rightClicked(Point2D p) {
        if (!Environment.IS_CONTROL_DOWN && JOptionPane.showConfirmDialog(MainFrame.getInstance(), "Sure you want delete this link between " + this.link.getLeft().getName() + " and " + this.link.getRight().getName(), "Delete...", 0) == 0) {
            this.delete();
        }
    }

    @Override
    public void edit() {
        if (!Environment.IS_CONTROL_DOWN) {
            try {
                MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.CHANGE, "Instance edited");
                EditLinkDialog eid = new EditLinkDialog(this.link);
                eid.setVisible(true);
                MainFrame.getInstance().repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Rectangle getPrintBounds() {
        Line2D l = this.getLine();
        int x1 = (int)l.getX1();
        int x2 = (int)l.getX2();
        int y1 = (int)l.getY1();
        int y2 = (int)l.getY2();
        return new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
    }

    @Override
    public boolean isOver() {
        return this.color == Environment.ASSOCIATION_COLOR;
    }
}

