/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.view;

import clews.History;
import clews.MainFrame;
import clews.data.Instance;
import clews.env.Environment;
import clews.gui.dialogs.EditInstanceDialog;
import clews.gui.view.ConfigurationView;
import clews.gui.view.PickableObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;

public class InstanceView
extends PickableObject {
    protected int lastx;
    protected int lasty;
    protected Color color;
    protected Instance instance;
    protected Point pos;
    protected int radius;
    protected Shape insttext;

    public InstanceView(Instance in, Point p) {
        super(true);
        this.instance = in;
        this.setSizeFromName();
        this.pos = new Point(p.x - (int)this.getRadius(), p.y - (int)this.getRadius());
        this.isSelected = false;
        this.unmark();
    }

    public Instance getInstance() {
        return this.instance;
    }

    public double getRadius() {
        return (double)this.radius / 2.0;
    }

    public void setSizeFromName() {
        this.insttext = null;
        this.setPositionChanged();
        if (this.instance.getName() != null) {
            this.insttext = Environment.getStandardText(this.instance.getName());
            this.radius = this.insttext.getBounds().width + 12;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.fillOval(this.pos.x, this.pos.y, this.radius, this.radius);
        Composite ocomp = g.getComposite();
        if (Environment.IS_CONTROL_DOWN && !this.isSelected) {
            g.setComposite(AlphaComposite.getInstance(3, Environment.CLASS_SELECTION_ALPHA));
        }
        Color col = this.color;
        if (!this.instance.isConsistent() && col.equals(Environment.CLASS_COLOR)) {
            col = Environment.CLASS_COLOR_INCONSISTENT;
        }
        g.setColor(col);
        g.drawOval(this.pos.x, this.pos.y, this.radius, this.radius);
        AffineTransform save = g.getTransform();
        g.transform(AffineTransform.getTranslateInstance(this.radius / 2 + this.pos.x - this.insttext.getBounds().width / 2, this.radius / 2 + this.pos.y - this.insttext.getBounds().height / 2));
        g.setColor(col);
        g.fill(this.insttext);
        this.positionChanged = false;
        g.setComposite(ocomp);
        g.setTransform(save);
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.pos.x + this.radius / 2, this.pos.y + this.radius / 2);
    }

    @Override
    public boolean contains(Point2D p) {
        double y;
        Point2D m = this.getCenter();
        double x = m.getX() - p.getX();
        return Math.sqrt(x * x + (y = m.getY() - p.getY()) * y) <= (double)(this.radius / 2);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.pos, new Dimension(this.radius, this.radius));
    }

    @Override
    public void clicked(Point2D p) {
        this.lastx = this.pos.x - (int)p.getX();
        this.lasty = this.pos.y - (int)p.getY();
        this.color = Environment.MARKED_CLASS_COLOR;
    }

    @Override
    public void mark() {
        this.color = Environment.MARKED_CLASS_COLOR;
    }

    @Override
    public void unmark() {
        this.color = Environment.CLASS_COLOR;
    }

    @Override
    public boolean setOver(boolean isOver) {
        Color save = this.color;
        this.color = isOver ? Environment.MOUSE_OVER_CLASS_COLOR : Environment.CLASS_COLOR;
        return save != this.color;
    }

    @Override
    public void release() {
        this.color = Environment.CLASS_COLOR;
    }

    @Override
    public void setLocation(Point p) {
    }

    @Override
    public void updateLocation(Point2D p) {
        this.pos = new Point(this.lastx + (int)p.getX(), this.lasty + (int)p.getY());
        this.positionChanged = true;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void rightClicked(Point2D p) {
        if (!Environment.IS_CONTROL_DOWN && JOptionPane.showConfirmDialog(MainFrame.getInstance(), "Sure you want delete " + this.instance.getName(), "Delete...", 0) == 0) {
            this.delete();
        }
    }

    @Override
    public void delete() {
        MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.DELETE, "Instance deleted");
        ((ConfigurationView)this.instance.getConfiguration().getView()).delete(this);
    }

    @Override
    public void edit() {
        if (!Environment.IS_CONTROL_DOWN) {
            try {
                MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.CHANGE, "Instance edited");
                EditInstanceDialog eid = new EditInstanceDialog(this.instance);
                eid.setVisible(true);
                MainFrame.getInstance().repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Rectangle getPrintBounds() {
        return this.getBounds();
    }

    @Override
    public boolean isOver() {
        return this.color != Environment.MARKED_CLASS_COLOR;
    }
}

