/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.view;

import clews.data.Class;
import clews.data.Configuration;
import clews.data.Instance;
import clews.data.Link;
import clews.gui.diagram.ConfigurationDiagram;
import clews.gui.view.InstanceView;
import clews.gui.view.LinkView;
import clews.gui.view.SelectableObject;
import clews.gui.view.ViewObject;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class ConfigurationView
extends ViewObject {
    protected ConfigurationDiagram diagram;
    protected Configuration config;
    protected ArrayList<LinkView> links;
    protected ArrayList<InstanceView> instances;

    public ConfigurationView(Configuration c) {
        this.config = c;
        this.diagram = new ConfigurationDiagram(this);
        this.links = new ArrayList();
        this.instances = new ArrayList();
        c.setPath(null);
    }

    public ConfigurationDiagram getDiagram() {
        return this.diagram;
    }

    public void delete(InstanceView iv) {
        this.config.delete(iv.getInstance());
        this.instances.remove(iv);
        ArrayList<Link> toDel = new ArrayList<Link>();
        for (Number n : iv.getInstance().getLinks().keySet()) {
            for (Link l : iv.getInstance().getLinks().get(n)) {
                toDel.add(l);
            }
        }
        for (Link l : toDel) {
            this.delete((LinkView)l.getView());
        }
        this.diagram.applyChanges();
    }

    public void delete(LinkView lv) {
        this.config.delete(lv.getLink());
        this.links.remove(lv);
        this.diagram.applyChanges();
    }

    public void clear() {
        this.links.clear();
        this.instances.clear();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Instance addDropInstance(Class c, Point p) {
        Instance inst = this.config.addInstance(c);
        InstanceView iv = new InstanceView(inst, p);
        inst.setView(iv);
        this.instances.add(iv);
        return inst;
    }

    public ArrayList<InstanceView> getInstances() {
        return this.instances;
    }

    public LinkView addNewLinkView(Link l) {
        LinkView lv = new LinkView(l);
        l.setView(lv);
        this.links.add(lv);
        return lv;
    }

    public ArrayList<LinkView> getLinks() {
        return this.links;
    }

    public void applyChanges() {
        this.config.applyChanges();
    }

    @Override
    public void draw(Graphics2D g) {
        ArrayList<SelectableObject> todraw = new ArrayList<SelectableObject>();
        for (LinkView linkView : this.links) {
            if (linkView.isOver()) {
                linkView.draw(g);
                continue;
            }
            todraw.add(linkView);
        }
        for (ViewObject viewObject : todraw) {
            viewObject.draw(g);
        }
        todraw = new ArrayList();
        for (InstanceView instanceView : this.instances) {
            if (instanceView.isSelected() || instanceView.isOver()) {
                instanceView.draw(g);
                continue;
            }
            todraw.add(instanceView);
        }
        for (ViewObject viewObject : todraw) {
            viewObject.draw(g);
        }
    }

    @Override
    public Rectangle getPrintBounds() {
        return null;
    }
}

