/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.view;

import clews.History;
import clews.MainFrame;
import clews.data.Class;
import clews.env.Environment;
import clews.gui.diagram.DiagramPanel;
import clews.gui.dialogs.EditClassDialog;
import clews.gui.view.PickableObject;
import clews.gui.view.SpecificationView;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;

public class ClassView
extends PickableObject {
    private static final long serialVersionUID = -4018680947156296745L;
    protected int lastx;
    protected int lasty;
    protected Color color;
    protected SpecificationView specificationView;
    protected Class classObj;
    protected Shape classtext;
    protected Rectangle classRect;

    public ClassView(SpecificationView sv, Class c) {
        super(true);
        this.specificationView = sv;
        this.classObj = c;
        this.lasty = -1;
        this.lastx = -1;
        this.color = Environment.CLASS_COLOR;
        this.isSelected = false;
        this.classRect = new Rectangle();
        this.setSizeFromName();
        DiagramPanel dp = MainFrame.getInstance().getDiagramPanel();
        if (dp != null) {
            this.setLocation(dp.getSize().width / 2, dp.getSize().height / 2);
        }
    }

    @Override
    public void setLocation(Point p) {
        this.classRect.setLocation(p);
    }

    @Override
    public Rectangle getBounds() {
        return this.classRect;
    }

    public void setSizeFromName() {
        this.classtext = null;
        if (this.classObj.getName() != null) {
            String orTxt = "";
            if (this.classObj.getMinPartner() != 0 || this.classObj.getMaxParnter() != Environment.CARDINALITY_STAR) {
                orTxt = "  {or[" + this.classObj.getMinPartner() + ".." + this.classObj.getMaxParnter() + "]}";
            }
            this.classtext = Environment.getBoldText(String.valueOf(this.classObj.getName()) + orTxt);
            int size = Math.max(this.classtext.getBounds().width, this.getMinSize()) + 20;
            this.classRect.setSize(size, size);
        }
    }

    public void setPosFromPosition(Point p) {
        this.setLocation(new Point(p.x - this.classRect.width / 2, p.y - this.classRect.height / 2));
    }

    protected int getMinSize() {
        return Environment.getSmallText((String)"MinObjects: ").getBounds().width + 20;
    }

    @Override
    public void draw(Graphics2D g) {
        AffineTransform old = g.getTransform();
        g.setColor(Environment.CLASS_INTERIOUR_COLOR);
        g.fill(this.classRect);
        Composite ocomp = g.getComposite();
        if (Environment.IS_CONTROL_DOWN && !this.isSelected) {
            g.setComposite(AlphaComposite.getInstance(3, Environment.CLASS_SELECTION_ALPHA));
        }
        if (this.classObj.isConsistent() || !this.color.equals(Environment.CLASS_COLOR)) {
            g.setColor(this.color);
        } else {
            g.setColor(Environment.CLASS_COLOR_INCONSISTENT);
        }
        g.draw(this.classRect);
        if (this.classtext != null) {
            AffineTransform save = g.getTransform();
            g.transform(AffineTransform.getTranslateInstance(this.classRect.x + 5, this.classRect.y + 5));
            g.fill(this.classtext);
            g.transform(AffineTransform.getTranslateInstance(0.0, 10 + this.classtext.getBounds().height));
            Shape last = Environment.getItalicText("MinObjects: " + this.classObj.getMinObj());
            g.fill(last);
            if (Environment.VIEW_DETAILS != Environment.ViewDetails.NO) {
                if (this.classObj.getMaxObj() != Environment.CARDINALITY_STAR) {
                    g.transform(AffineTransform.getTranslateInstance(0.0, last.getBounds().height));
                    g.fill(Environment.getItalicText("MaxObjects: " + this.classObj.getMaxObj()));
                }
                g.transform(AffineTransform.getTranslateInstance(0.0, last.getBounds().height));
                g.fill(Environment.getItalicText("Weight: " + this.classObj.getWeight()));
                g.transform(AffineTransform.getTranslateInstance(0.0, last.getBounds().height + 2));
                String text = "MinModel: ";
                text = this.specificationView.getSpecification().isConsistent() ? String.valueOf(text) + this.classObj.getMinModelObj() : String.valueOf(text) + "---";
                last = Environment.getItalicText(text);
                g.fill(last);
            }
            g.setTransform(save);
        }
        g.setComposite(ocomp);
        g.setTransform(old);
    }

    @Override
    public void clicked(Point2D p) {
        this.lastx = this.classRect.x - (int)p.getX();
        this.lasty = this.classRect.y - (int)p.getY();
        this.color = Environment.MARKED_CLASS_COLOR;
    }

    @Override
    public void mark() {
        this.color = Environment.MARKED_CLASS_COLOR;
    }

    @Override
    public void unmark() {
        this.color = Environment.CLASS_COLOR;
    }

    @Override
    public boolean setOver(boolean isOver) {
        Color save = this.color;
        this.color = isOver ? Environment.MOUSE_OVER_CLASS_COLOR : Environment.CLASS_COLOR;
        return save != this.color;
    }

    @Override
    public void release() {
        this.color = Environment.CLASS_COLOR;
    }

    @Override
    public void updateLocation(Point2D p) {
        this.classRect.setLocation(this.lastx + (int)p.getX(), this.lasty + (int)p.getY());
    }

    public Color getColor() {
        return this.color;
    }

    public Class getClassObject() {
        return this.classObj;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.classRect.contains(p);
    }

    @Override
    public void rightClicked(Point2D p) {
        if (!Environment.IS_CONTROL_DOWN && JOptionPane.showConfirmDialog(MainFrame.getInstance().getDiagramPanel(), "Sure you want delete " + this.classObj.getName(), "Delete...", 0) == 0) {
            this.delete();
        }
    }

    @Override
    public void delete() {
        MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.DELETE, "Class deleted");
        this.specificationView.delete(this);
    }

    @Override
    public void edit() {
        if (!Environment.IS_CONTROL_DOWN) {
            try {
                MainFrame.getInstance().getDomain().getHistory().addUndo(null, History.Operation.CHANGE, "Class changed");
                EditClassDialog ecd = new EditClassDialog(this.classObj);
                Object save = this.clone();
                ecd.setVisible(true);
                this.setSizeFromName();
                this.specificationView.getDiagram().applyChanges();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Rectangle getPrintBounds() {
        return this.getBounds();
    }

    @Override
    public boolean isOver() {
        return this.color == Environment.MARKED_CLASS_COLOR;
    }
}

