/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.view;

import clews.History;
import clews.MainFrame;
import clews.data.Association;
import clews.env.Environment;
import clews.gui.dialogs.EditAssociationDialog;
import clews.gui.view.ClassView;
import clews.gui.view.SelectableObject;
import clews.gui.view.SpecificationView;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;

public class AssociationView
extends SelectableObject {
    protected Association assoc;
    protected Color color;
    protected SpecificationView specificationView;
    protected Rectangle2D outer;
    protected Rectangle2D inner;
    protected boolean showDetails;

    public AssociationView(SpecificationView sv, Association a) {
        super(true);
        this.specificationView = sv;
        this.assoc = a;
        this.color = Environment.ASSOCIATION_COLOR;
        this.showDetails = true;
        this.createPickingSelfJoin();
    }

    @Override
    public void mark() {
        this.color = Environment.MOUSE_OVER_ASSOCIATION_COLOR;
    }

    @Override
    public void unmark() {
        this.color = Environment.ASSOCIATION_COLOR;
    }

    public void setShowDetails(boolean show) {
        this.showDetails = show;
    }

    public boolean getShowDetails() {
        return this.showDetails;
    }

    @Override
    public void draw(Graphics2D g) {
        AffineTransform save = g.getTransform();
        Composite ocomp = g.getComposite();
        if (Environment.IS_CONTROL_DOWN) {
            g.setComposite(AlphaComposite.getInstance(3, Environment.CLASS_SELECTION_ALPHA));
        }
        Rectangle cv1 = this.getLeftView().getBounds();
        Rectangle cv2 = this.getRightView().getBounds();
        if (this.assoc.isConsistent() || !this.color.equals(Environment.ASSOCIATION_COLOR)) {
            g.setColor(this.color);
        } else {
            g.setColor(Environment.CLASS_COLOR_INCONSISTENT);
        }
        if (cv1 != cv2) {
            g.draw(this.getLine());
            this.drawEnd(g, cv1, cv2, this.assoc.getTypeLeft().name(), this.getCard(this.assoc.getMinLeft(), this.assoc.getLeft().getConstrainedMin(), this.assoc.getMaxLeft(), this.assoc.getLeft().getConstrainedMax()));
            this.drawEnd(g, cv2, cv1, this.assoc.getTypeRight().name(), this.getCard(this.assoc.getMinRight(), this.assoc.getRight().getConstrainedMin(), this.assoc.getMaxRight(), this.assoc.getRight().getConstrainedMax()));
            if (this.showDetails && Environment.VIEW_DETAILS == Environment.ViewDetails.ALL) {
                this.drawName(g, cv1, cv2);
            }
        } else {
            g.draw(this.getSelfRect());
            this.drawEnd(g, cv1, new Rectangle(cv1.x, cv1.y - 2 * cv1.height, cv1.height, cv1.width), this.assoc.getTypeLeft().name(), this.getCard(this.assoc.getMinLeft(), this.assoc.getLeft().getConstrainedMin(), this.assoc.getMaxLeft(), this.assoc.getLeft().getConstrainedMax()));
            this.drawEnd(g, cv1, new Rectangle(cv1.x - 2 * cv1.width, cv1.y, cv1.height, cv1.width), this.assoc.getTypeRight().name(), this.getCard(this.assoc.getMinRight(), this.assoc.getRight().getConstrainedMin(), this.assoc.getMaxRight(), this.assoc.getRight().getConstrainedMax()));
        }
        g.setComposite(ocomp);
        g.setTransform(save);
    }

    protected Rectangle getSelfRect() {
        Rectangle cv1 = this.getLeftView().getBounds();
        Rectangle cv2 = this.getRightView().getBounds();
        return new Rectangle(cv1.x - cv1.width, cv1.y - cv1.height, cv1.width * 3 / 2, cv1.height * 3 / 2);
    }

    @Override
    public boolean contains(Point2D mp) {
        if (this.getLeftView() != this.getRightView()) {
            return this.getLine().ptSegDist(mp) < Environment.ASSOCIATION_PICKING_SENSITVITY;
        }
        this.createPickingSelfJoin();
        return this.outer.contains(mp) && !this.inner.contains(mp);
    }

    protected void createPickingSelfJoin() {
        Rectangle cv1 = this.getLeftView().getBounds();
        double ps = Environment.ASSOCIATION_PICKING_SENSITVITY;
        this.outer = new Rectangle2D.Double((double)(cv1.x - cv1.width) - ps, (double)(cv1.y - cv1.height) - ps, (double)(cv1.width * 3 / 2) + 2.0 * ps, (double)(cv1.height * 3 / 2) + 2.0 * ps);
        this.inner = new Rectangle2D.Double((double)(cv1.x - cv1.width) + ps, (double)(cv1.y - cv1.height) + ps, (double)(cv1.width * 3 / 2) - ps, (double)(cv1.height * 3 / 2) - ps);
    }

    public Line2D getLine() {
        Rectangle cv1 = this.getLeftView().getBounds();
        Rectangle cv2 = this.getRightView().getBounds();
        return new Line2D.Double(cv1.getCenterX(), cv1.getCenterY(), cv2.getCenterX(), cv2.getCenterY());
    }

    protected String getCard(int min, int max, int cmax) {
        String ret = String.valueOf(min) + "..";
        ret = max == -1 ? String.valueOf(ret) + "*" : String.valueOf(ret) + max;
        if (cmax != max) {
            ret = String.valueOf(ret) + " / " + this.getCard(min, cmax, cmax);
        }
        return ret;
    }

    protected String getCard(int min, int cmin, int max, int cmax) {
        String ret = String.valueOf(min) + "..";
        ret = max == -1 ? String.valueOf(ret) + "*" : String.valueOf(ret) + max;
        if (cmin != min || cmax != max) {
            ret = String.valueOf(ret) + " / " + this.getCard(cmin, cmin, cmax, cmax);
        }
        return ret;
    }

    @Override
    public boolean setOver(boolean isOver) {
        Color save = this.color;
        this.color = isOver ? Environment.MOUSE_OVER_ASSOCIATION_COLOR : Environment.ASSOCIATION_COLOR;
        return save != this.color;
    }

    protected double getLineAngle(Rectangle cv1, Rectangle cv2) {
        double dx = cv2.getCenterX() - cv1.getCenterX();
        double dy = cv2.getCenterY() - cv1.getCenterY();
        double alpha = Math.acos(dx / Math.sqrt(dx * dx + dy * dy));
        if (dy < 0.0) {
            alpha = Math.PI * 2 - alpha;
        }
        return alpha;
    }

    protected double getLineLength() {
        Line2D l = this.getLine();
        return Math.sqrt(Math.pow(l.getX1() - l.getX2(), 2.0) + Math.pow(l.getY1() - l.getY2(), 2.0));
    }

    protected void drawName(Graphics2D g, Rectangle cv1, Rectangle cv2) {
        int arrowShift;
        int mul;
        double alpha = this.getLineAngle(cv1, cv2);
        Shape name = Environment.getSmallText(this.assoc.getName());
        AffineTransform save = g.getTransform();
        g.transform(AffineTransform.getTranslateInstance(cv1.getCenterX(), cv1.getCenterY()));
        double shift = this.getLineLength() / 2.0 - (double)(name.getBounds().width / 2);
        g.rotate(alpha);
        if (alpha >= 1.5707963267948966 && alpha < 4.71238898038469) {
            g.rotate(Math.PI);
            g.translate(-shift - (double)name.getBounds().width, (double)(-name.getBounds().height - 17));
            mul = 1;
            arrowShift = 0;
        } else {
            g.translate(shift, (double)(-name.getBounds().height - 17));
            arrowShift = name.getBounds().width;
            mul = -1;
        }
        g.fill(name);
        int s = 20;
        g.translate((double)(mul * (-s - 5)), 0.0);
        Polygon p = new Polygon();
        p.addPoint(arrowShift + mul * (s - name.getBounds().height), name.getBounds().height / 2);
        p.addPoint(arrowShift + mul * s, name.getBounds().height);
        p.addPoint(arrowShift + mul * s, 0);
        g.fill(p);
        g.setTransform(save);
    }

    protected void drawEnd(Graphics2D g, Rectangle cv1, Rectangle cv2, String typestr, String cardstr) {
        int cardtrans;
        AffineTransform save = g.getTransform();
        Color oldcolor = g.getColor();
        if (cardstr.contains("/")) {
            g.setColor(Environment.ASSOCIATION_CONSTRAINT);
        }
        double alpha = this.getLineAngle(cv1, cv2);
        g.transform(AffineTransform.getTranslateInstance(cv1.getCenterX(), cv1.getCenterY()));
        Shape card = Environment.getStandardText(cardstr);
        Shape type = Environment.getStandardText(typestr.replace("_", "-").toLowerCase());
        double shift = (cv1.getWidth() / 2.0 + 15.0) * this.scaleForAngle(alpha);
        if (alpha >= 1.5707963267948966 && alpha < 4.71238898038469) {
            g.rotate(Math.PI);
            g.rotate(alpha);
            g.translate(-shift - (double)type.getBounds().width, (double)(-type.getBounds().height - 5));
            cardtrans = (type.getBounds().width - card.getBounds().width - 10) / 2;
        } else {
            g.rotate(alpha);
            g.translate(shift, (double)(-type.getBounds().height - 5));
            cardtrans = (type.getBounds().width - card.getBounds().width - 10) / 2;
        }
        if (Environment.VIEW_DETAILS != Environment.ViewDetails.NO) {
            g.fill(type);
        }
        g.translate(cardtrans, type.getBounds().height + card.getBounds().height);
        g.fill(card);
        g.setTransform(save);
        g.setColor(oldcolor);
    }

    public double scaleForAngle(double angle) {
        double delta = angle <= 1.5707963267948966 && angle >= 0.0 ? angle - 0.0 : (angle <= Math.PI && angle >= 1.5707963267948966 ? angle - 1.5707963267948966 : (angle <= 4.71238898038469 && angle >= Math.PI ? angle - Math.PI : angle - 4.71238898038469));
        if (delta > 0.7853981633974483) {
            delta = 1.5707963267948966 - delta;
        }
        return 1.0 + (Math.sqrt(1.75) - 1.0) * (delta /= 0.7853981633974483);
    }

    public ClassView getLeftView() {
        return (ClassView)this.assoc.getLeftClass().getView();
    }

    public ClassView getRightView() {
        return (ClassView)this.assoc.getRightClass().getView();
    }

    public Association getAssociationObject() {
        return this.assoc;
    }

    @Override
    public void clicked(Point2D p) {
    }

    @Override
    public void release() {
    }

    @Override
    public void rightClicked(Point2D p) {
        if (!Environment.IS_CONTROL_DOWN && JOptionPane.showConfirmDialog(MainFrame.getInstance().getDiagramPanel(), "Sure you want delete " + this.assoc.getName(), "Delete...", 0) == 0) {
            this.delete();
        }
    }

    @Override
    public void delete() {
        MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.DELETE, "Association deleted");
        this.specificationView.delete(this);
    }

    @Override
    public void edit() {
        if (!Environment.IS_CONTROL_DOWN) {
            try {
                MainFrame.getInstance().getDomain().getHistory().addUndo(this, History.Operation.CHANGE, "Association changed");
                EditAssociationDialog ead = new EditAssociationDialog(this.assoc);
                ead.setVisible(true);
                this.specificationView.getDiagram().applyChanges();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Rectangle getPrintBounds() {
        Rectangle cv2;
        Rectangle cv1 = this.getLeftView().getBounds();
        if (cv1 != (cv2 = this.getRightView().getBounds())) {
            Line2D l = this.getLine();
            int x1 = (int)l.getX1();
            int x2 = (int)l.getX2();
            int y1 = (int)l.getY1();
            int y2 = (int)l.getY2();
            return new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
        }
        return this.getSelfRect();
    }

    @Override
    public boolean isOver() {
        return this.color == Environment.MOUSE_OVER_ASSOCIATION_COLOR;
    }
}

