/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.dialogs;

import clews.MainFrame;
import clews.data.Association;
import clews.data.Constraint;
import clews.env.Environment;
import clews.gui.view.ConstraintView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EditConstraintDialog
extends JDialog {
    private static final long serialVersionUID = 3291489701988978561L;
    protected Constraint constraint;
    protected JTextField constraintName;
    protected JTextArea lhs;
    protected JTextArea rhs;
    protected JCheckBox active;
    protected EditConstraintDialog instance;

    public EditConstraintDialog(Constraint c) {
        super((Window)MainFrame.getInstance(), "Edit Constraint", Dialog.ModalityType.DOCUMENT_MODAL);
        Environment.CURRENT_DIALOG = this;
        this.instance = this;
        this.constraint = c;
        Container parent = this.getContentPane();
        parent.setLayout(new BorderLayout());
        JPanel upp = new JPanel(new GridLayout(2, 1));
        JPanel up = new JPanel(new BorderLayout());
        up.add((Component)new JLabel("Name: "), "West");
        this.constraintName = new JTextField(c.getName());
        up.add((Component)this.constraintName, "Center");
        this.active = new JCheckBox("Is constraint active");
        up.add((Component)this.active, "East");
        this.active.setSelected(this.constraint.isActive());
        JPanel labs = new JPanel(new BorderLayout());
        labs.add((Component)new JLabel("Left hand side"), "West");
        labs.add((Component)new JLabel("Right hand side"), "East");
        JPanel p2 = new JPanel(new BorderLayout());
        this.lhs = new JTextArea(6, 22);
        p2.add((Component)new JScrollPane(this.lhs), "West");
        p2.add((Component)new JLabel(" = "), "Center");
        this.rhs = new JTextArea(6, 22);
        p2.add((Component)new JScrollPane(this.rhs), "East");
        for (Constraint.ConstraintPart cp : this.constraint.getLhs()) {
            this.lhs.setText(String.valueOf(this.lhs.getText()) + cp.association.getName() + (cp.inv ? Environment.ASSOCIATION_INVERSE : "") + "\n");
        }
        for (Constraint.ConstraintPart cp : this.constraint.getRhs()) {
            this.rhs.setText(String.valueOf(this.rhs.getText()) + cp.association.getName() + (cp.inv ? Environment.ASSOCIATION_INVERSE : "") + "\n");
        }
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel p3 = new JPanel(new FlowLayout());
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        JButton delete = new JButton("Delete");
        p3.add(delete);
        p3.add(cancel);
        p3.add(ok);
        bottom.add((Component)p3, "East");
        JPanel desc = new JPanel(new BorderLayout());
        desc.add((Component)new JLabel("Available associations"), "North");
        JTextArea descs = new JTextArea();
        desc.add((Component)new JScrollPane(descs), "Center");
        desc.add((Component)bottom, "South");
        descs.setEditable(false);
        String text = "";
        for (Association a : this.constraint.getSpecification().getAssociations()) {
            text = String.valueOf(text) + a.getName() + ":   " + a.getLeft().assclass.getName() + " --- " + a.getRight().assclass.getName() + "\n";
        }
        descs.setRows(Math.min(10, this.constraint.getSpecification().getAssociations().size() + 1));
        descs.setText(text);
        upp.add(up);
        upp.add(labs);
        parent.add((Component)upp, "North");
        parent.add((Component)p2, "Center");
        parent.add((Component)desc, "South");
        ok.addActionListener(new OkListener());
        cancel.addActionListener(new CancelListener());
        delete.addActionListener(new DeleteListener());
        this.setResizable(false);
        this.setLocationRelativeTo(MainFrame.getInstance());
        this.pack();
    }

    public void close() {
        Environment.CURRENT_DIALOG = null;
        this.setVisible(false);
    }

    public boolean checkParts(ArrayList<Constraint.ConstraintPart> acp) {
        int i = 0;
        while (i < acp.size() - 1) {
            if (!this.constraint.match(acp.get(i), acp.get(i + 1)) || acp.get((int)i).association.getTypeLeft() != acp.get((int)0).association.getTypeLeft()) {
                JOptionPane.showMessageDialog(this, "Associations '" + acp.get((int)i).association.getName() + "' and '" + acp.get((int)(i + 1)).association.getName() + "' do not match.");
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean getAssociations(JTextArea ta, boolean lhs) {
        if (!ta.getText().equals("")) {
            String[] strs = ta.getText().split("\n");
            int i = 0;
            while (i < strs.length) {
                String search = strs[i].replace(Environment.ASSOCIATION_INVERSE, "");
                if (!search.equals("")) {
                    Association assoc = this.constraint.getSpecification().getAssociationForName(search);
                    if (assoc == null) {
                        JOptionPane.showMessageDialog(this, "Unknown association '" + search + "'");
                        return false;
                    }
                    if (lhs) {
                        this.constraint.addLhsPart(assoc, strs[i].endsWith(Environment.ASSOCIATION_INVERSE));
                    } else {
                        this.constraint.addRhsPart(assoc, strs[i].endsWith(Environment.ASSOCIATION_INVERSE));
                    }
                }
                ++i;
            }
        }
        return true;
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            EditConstraintDialog.this.close();
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ((ConstraintView)EditConstraintDialog.this.constraint.getView()).delete();
            EditConstraintDialog.this.close();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (EditConstraintDialog.this.constraintName != null && !EditConstraintDialog.this.constraintName.getText().equals("")) {
                EditConstraintDialog.this.constraint.setName(EditConstraintDialog.this.constraintName.getText());
            }
            EditConstraintDialog.this.constraint.setActive(EditConstraintDialog.this.active.isSelected());
            if (EditConstraintDialog.this.constraint.isActive()) {
                EditConstraintDialog.this.constraint.clear();
                if (EditConstraintDialog.this.getAssociations(EditConstraintDialog.this.lhs, true) && EditConstraintDialog.this.getAssociations(EditConstraintDialog.this.rhs, false) && EditConstraintDialog.this.checkParts(EditConstraintDialog.this.constraint.getLhs()) && EditConstraintDialog.this.checkParts(EditConstraintDialog.this.constraint.getRhs())) {
                    if (EditConstraintDialog.this.constraint.computeResultingInterval()) {
                        for (Constraint.ConstraintPart cp : EditConstraintDialog.this.constraint.getLhs()) {
                            cp.association.getLeft().setConstrainedMin(cp.association.getConstrainedMinLeft());
                            cp.association.getLeft().setConstrainedMax(cp.association.getConstrainedMaxLeft());
                            cp.association.getRight().setConstrainedMin(cp.association.getConstrainedMinRight());
                            cp.association.getRight().setConstrainedMax(cp.association.getConstrainedMaxRight());
                        }
                        for (Constraint.ConstraintPart cp : EditConstraintDialog.this.constraint.getRhs()) {
                            cp.association.getLeft().setConstrainedMin(cp.association.getConstrainedMinLeft());
                            cp.association.getLeft().setConstrainedMax(cp.association.getConstrainedMaxLeft());
                            cp.association.getRight().setConstrainedMin(cp.association.getConstrainedMinRight());
                            cp.association.getRight().setConstrainedMax(cp.association.getConstrainedMaxRight());
                        }
                        EditConstraintDialog.this.close();
                    } else {
                        JOptionPane.showMessageDialog(EditConstraintDialog.this.instance, EditConstraintDialog.this.constraint.getErrorMessage());
                    }
                }
            } else {
                for (Constraint.ConstraintPart cp : EditConstraintDialog.this.constraint.getLhs()) {
                    cp.association.getLeft().setConstrainedMin(cp.association.getMinLeft());
                    cp.association.getLeft().setConstrainedMax(cp.association.getMaxLeft());
                    cp.association.getRight().setConstrainedMin(cp.association.getMinRight());
                    cp.association.getRight().setConstrainedMax(cp.association.getMaxRight());
                }
                for (Constraint.ConstraintPart cp : EditConstraintDialog.this.constraint.getRhs()) {
                    cp.association.getLeft().setConstrainedMin(cp.association.getMinLeft());
                    cp.association.getLeft().setConstrainedMax(cp.association.getMaxLeft());
                    cp.association.getRight().setConstrainedMin(cp.association.getMinRight());
                    cp.association.getRight().setConstrainedMax(cp.association.getMaxRight());
                }
                EditConstraintDialog.this.close();
            }
        }
    }
}

