/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.dialogs;

import clews.MainFrame;
import clews.data.Association;
import clews.data.Class;
import clews.env.Environment;
import clews.env.Utils;
import clews.gui.view.ClassView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EditClassDialog
extends JDialog {
    private static final long serialVersionUID = -9166600668896259280L;
    protected JTextField classname;
    protected JTextField minobj;
    protected JTextField weight;
    protected JTextField maxobj;
    protected JTextField minpartner;
    protected JTextField maxpartner;
    protected JTextArea partners;
    protected Class data;
    protected EditClassDialog instance;

    public EditClassDialog(Class c) {
        super((Window)MainFrame.getInstance(), "Edit Class", Dialog.ModalityType.DOCUMENT_MODAL);
        Environment.CURRENT_DIALOG = this;
        this.data = c;
        Container parent = this.getContentPane();
        this.instance = this;
        parent.setLayout(new BorderLayout());
        JPanel p1 = new JPanel(new GridLayout(6, 2));
        p1.add(new JLabel("Name: "));
        this.classname = new JTextField(c.getName(), 15);
        p1.add(this.classname);
        this.minobj = new JTextField("" + c.getMinObj(), 5);
        p1.add(new JLabel("Minimum Objects: "));
        p1.add(this.minobj);
        this.weight = new JTextField("" + c.getWeight(), 5);
        p1.add(new JLabel("Weight: "));
        p1.add(this.weight);
        this.maxobj = new JTextField(Utils.toStarNum(c.getMaxObj()), 5);
        p1.add(new JLabel("Maximum Objects: "));
        p1.add(this.maxobj);
        this.minpartner = new JTextField("" + c.getMinPartner(), 5);
        p1.add(new JLabel("OR Minimum: "));
        p1.add(this.minpartner);
        this.maxpartner = new JTextField(Utils.toStarNum(c.getMaxParnter()), 5);
        p1.add(new JLabel("OR Maximum: "));
        p1.add(this.maxpartner);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)new JLabel("Associations for XOR Constraint"), "North");
        this.partners = new JTextArea(6, 22);
        p2.add((Component)new JScrollPane(this.partners), "Center");
        String text = "";
        try {
            for (int cl : c.getOrPartner()) {
                text = String.valueOf(text) + c.getSpecification().getClassById(cl).getName() + "\n";
            }
        }
        catch (Exception e) {
            System.out.println("Problem beim Einlesen: " + e);
        }
        this.partners.setRows(Math.min(10, c.getOrPartner().size() + 1));
        this.partners.setText(text);
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel p3 = new JPanel(new FlowLayout());
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        JButton delete = new JButton("Delete");
        p3.add(delete);
        p3.add(cancel);
        p3.add(ok);
        bottom.add((Component)p3, "East");
        JPanel desc = new JPanel(new BorderLayout());
        desc.add((Component)new JLabel("Available associations"), "North");
        JTextArea descs = new JTextArea();
        desc.add((Component)new JScrollPane(descs), "Center");
        desc.add((Component)bottom, "South");
        descs.setEditable(false);
        text = "";
        for (Association a : c.getSpecification().getAssociations()) {
            if (a.getLeftClass() == c) {
                text = String.valueOf(text) + a.getRightClass().getName() + "\n";
                continue;
            }
            if (a.getRightClass() != c) continue;
            text = String.valueOf(text) + a.getLeftClass().getName() + "\n";
        }
        descs.setRows(Math.min(10, c.getSpecification().getAssociations().size() + 1));
        descs.setText(text);
        parent.add((Component)p1, "North");
        parent.add((Component)p2, "Center");
        parent.add((Component)desc, "South");
        ok.addActionListener(new OkListener());
        cancel.addActionListener(new CancelListener());
        delete.addActionListener(new DeleteListener());
        this.setResizable(false);
        this.setLocationRelativeTo(MainFrame.getInstance());
        this.pack();
    }

    public void close() {
        Environment.CURRENT_DIALOG = null;
        this.setVisible(false);
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            EditClassDialog.this.close();
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ((ClassView)EditClassDialog.this.data.getView()).delete();
            EditClassDialog.this.close();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (EditClassDialog.this.classname != null && !EditClassDialog.this.classname.getText().equals("")) {
                EditClassDialog.this.data.setName(EditClassDialog.this.classname.getText());
            }
            if (EditClassDialog.this.minobj != null && Utils.isInteger(EditClassDialog.this.minobj.getText())) {
                EditClassDialog.this.data.setMinObj(Integer.parseInt(EditClassDialog.this.minobj.getText()));
            }
            if (EditClassDialog.this.weight != null && Utils.isInteger(EditClassDialog.this.weight.getText())) {
                EditClassDialog.this.data.setWeight(Integer.parseInt(EditClassDialog.this.weight.getText()));
            }
            if (EditClassDialog.this.maxobj != null) {
                EditClassDialog.this.data.setMaxObj(Utils.fromStarNum(EditClassDialog.this.maxobj.getText(), EditClassDialog.this.data.getMaxObj()));
            }
            if (EditClassDialog.this.minpartner != null && Utils.isInteger(EditClassDialog.this.minpartner.getText())) {
                EditClassDialog.this.data.setMinPartner(Integer.parseInt(EditClassDialog.this.minpartner.getText()));
            }
            if (EditClassDialog.this.maxpartner != null) {
                EditClassDialog.this.data.setMaxPartner(Utils.fromStarNum(EditClassDialog.this.maxpartner.getText(), EditClassDialog.this.data.getMaxParnter()));
            }
            boolean ok = true;
            if (EditClassDialog.this.partners != null && !EditClassDialog.this.partners.getText().equals("")) {
                String[] strs = EditClassDialog.this.partners.getText().split("\n");
                int i = 0;
                while (i < strs.length) {
                    String search = strs[i];
                    if (!search.equals("")) {
                        Class cl = EditClassDialog.this.data.getSpecification().getClassForName(search);
                        if (cl == null) {
                            EditClassDialog.this.data.setErrorMessage("Unknown class '" + search + "'");
                            ok = false;
                            break;
                        }
                        EditClassDialog.this.data.setOrPartner(cl.getId());
                    }
                    ++i;
                }
            }
            if (ok) {
                EditClassDialog.this.close();
            } else {
                String message = EditClassDialog.this.data.getErrorMessage();
                JOptionPane.showMessageDialog(EditClassDialog.this.instance, message);
            }
        }
    }
}

