/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.dialogs;

import clews.MainFrame;
import clews.data.Association;
import clews.data.AssociationAttribute;
import clews.data.Constraint;
import clews.env.Environment;
import clews.gui.view.AssociationView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class EditAssociationDialog
extends JDialog {
    private static final long serialVersionUID = 327340088344680920L;
    protected Association assoc;
    protected JComboBox typeleft;
    protected JComboBox typeright;
    protected JTextField minleft;
    protected JTextField maxleft;
    protected JTextField minright;
    protected JTextField maxright;
    protected JTextField name;
    protected JCheckBox showDetails;

    public EditAssociationDialog(Association a) {
        super((Window)MainFrame.getInstance(), "Edit Association", Dialog.ModalityType.DOCUMENT_MODAL);
        Environment.CURRENT_DIALOG = this;
        Container parent = this.getContentPane();
        this.assoc = a;
        parent.setLayout(new BorderLayout());
        JPanel all = new JPanel();
        all.setLayout(new BorderLayout());
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        left.setName("");
        left.setLayout(new FlowLayout());
        right.setLayout(new FlowLayout());
        left.setBorder(new TitledBorder("End " + this.assoc.getLeft().assclass.getName()));
        right.setBorder(new TitledBorder("End " + this.assoc.getRight().assclass.getName()));
        JPanel up = new JPanel();
        up.setLayout(new BorderLayout());
        up.add((Component)new JLabel("Name: "), "West");
        this.name = new JTextField(this.assoc.getName());
        up.add((Component)this.name, "Center");
        this.showDetails = new JCheckBox("Show details", ((AssociationView)this.assoc.getView()).getShowDetails());
        up.add((Component)this.showDetails, "East");
        up.doLayout();
        all.add((Component)up, "North");
        all.add((Component)left, "Center");
        all.add((Component)right, "South");
        this.typeleft = this.createCombo();
        this.typeright = this.createCombo();
        this.typeleft.setSelectedItem((Object)this.assoc.getTypeLeft());
        this.typeright.setSelectedItem((Object)this.assoc.getTypeRight());
        this.minleft = new JTextField("" + this.assoc.getMinLeft(), 3);
        this.maxleft = new JTextField(this.assoc.getMaxLeft() == Environment.CARDINALITY_STAR ? "*" : "" + this.assoc.getMaxLeft(), 3);
        this.minright = new JTextField("" + this.assoc.getMinRight(), 3);
        this.maxright = new JTextField(this.assoc.getMaxRight() == Environment.CARDINALITY_STAR ? "*" : "" + this.assoc.getMaxRight(), 3);
        left.add(new JLabel("Type: "));
        left.add(this.typeleft);
        left.add(new JLabel("Minimum: "));
        left.add(this.minleft);
        left.add(new JLabel("Maximum: "));
        left.add(this.maxleft);
        right.add(new JLabel("Type: "));
        right.add(this.typeright);
        right.add(new JLabel("Minimum: "));
        right.add(this.minright);
        right.add(new JLabel("Maximum: "));
        right.add(this.maxright);
        JPanel buttongrid = new JPanel();
        JButton delete = new JButton("Delete");
        JButton cancel = new JButton("Cancel");
        JButton ok = new JButton("Ok");
        ok.addActionListener(new OkListener());
        cancel.addActionListener(new CancelListener());
        delete.addActionListener(new DeleteListener());
        buttongrid.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(delete);
        buttons.add(cancel);
        buttons.add(ok);
        buttongrid.add((Component)buttons, "East");
        parent.add((Component)all, "Center");
        parent.add((Component)buttongrid, "South");
        this.setResizable(false);
        this.setLocationRelativeTo(MainFrame.getInstance());
        this.pack();
    }

    protected JComboBox createCombo() {
        AssociationAttribute[] types = AssociationAttribute.values();
        return new JComboBox<AssociationAttribute>(types);
    }

    public void close() {
        Environment.CURRENT_DIALOG = null;
        this.setVisible(false);
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            EditAssociationDialog.this.close();
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ((AssociationView)EditAssociationDialog.this.assoc.getView()).delete();
            EditAssociationDialog.this.close();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (EditAssociationDialog.this.name.getText() != null && EditAssociationDialog.this.name.getText().length() > 0) {
                EditAssociationDialog.this.assoc.setName(EditAssociationDialog.this.name.getText());
            }
            EditAssociationDialog.this.assoc.setTypes((AssociationAttribute)((Object)EditAssociationDialog.this.typeleft.getSelectedItem()), (AssociationAttribute)((Object)EditAssociationDialog.this.typeright.getSelectedItem()));
            ((AssociationView)EditAssociationDialog.this.assoc.getView()).setShowDetails(EditAssociationDialog.this.showDetails.isSelected());
            int mil = EditAssociationDialog.this.assoc.getMinLeft();
            int mir = EditAssociationDialog.this.assoc.getMinRight();
            int mal = EditAssociationDialog.this.assoc.getMaxLeft();
            int mar = EditAssociationDialog.this.assoc.getMaxRight();
            mil = this.getInteger(EditAssociationDialog.this.minleft, mil);
            mal = this.getInteger(EditAssociationDialog.this.maxleft, mal);
            mir = this.getInteger(EditAssociationDialog.this.minright, mir);
            mar = this.getInteger(EditAssociationDialog.this.maxright, mar);
            for (Constraint.ConstraintPart cp : EditAssociationDialog.this.assoc.getConstraints()) {
                if (!cp.constraint.isActive()) continue;
                EditAssociationDialog.this.assoc.getLeft().setConstrainedMin(EditAssociationDialog.this.assoc.getConstrainedMinLeft());
                EditAssociationDialog.this.assoc.getLeft().setConstrainedMax(EditAssociationDialog.this.assoc.getConstrainedMaxLeft());
                EditAssociationDialog.this.assoc.getRight().setConstrainedMin(EditAssociationDialog.this.assoc.getConstrainedMinRight());
                EditAssociationDialog.this.assoc.getRight().setConstrainedMax(EditAssociationDialog.this.assoc.getConstrainedMaxRight());
            }
            EditAssociationDialog.this.assoc.setCards(mil, mal, mir, mar);
            EditAssociationDialog.this.close();
        }

        public int getInteger(JTextField tf, int stdval) {
            int ret = stdval;
            if (tf.getText() != null && !tf.getText().equals("")) {
                if (tf.getText().equals("*")) {
                    ret = -1;
                } else {
                    try {
                        ret = Integer.parseInt(tf.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return ret;
        }
    }
}

