/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.diagram;

import clews.History;
import clews.MainFrame;
import clews.gui.diagram.Diagram;
import clews.gui.view.AssociationView;
import clews.gui.view.ClassView;
import clews.gui.view.PickableObject;
import clews.gui.view.SpecificationView;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class SpecificationDiagram
extends Diagram<ClassView, AssociationView> {
    protected SpecificationView specificationView;

    public SpecificationDiagram(SpecificationView sv) {
        super(MainFrame.getInstance().getDiagramPanel());
        this.specificationView = sv;
    }

    @Override
    public String getName() {
        return "Specification";
    }

    @Override
    public void connect(PickableObject po1, PickableObject po2) {
        MainFrame.getInstance().getDomain().getHistory().addUndo(null, History.Operation.ADD, "Association added");
        this.specificationView.addNewAssociationView(this.specificationView.getSpecification().associate(((ClassView)po1).getClassObject(), ((ClassView)po2).getClassObject()));
        this.applyChanges();
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.specificationView != null) {
            this.specificationView.draw(g);
        }
        super.draw(g);
    }

    @Override
    public ArrayList<ClassView> getPickableObjects() {
        if (this.specificationView != null) {
            return this.specificationView.getClasses();
        }
        return new ArrayList<ClassView>();
    }

    @Override
    public ArrayList<AssociationView> getSelectableObjects() {
        if (this.specificationView != null) {
            return this.specificationView.getAssociations();
        }
        return new ArrayList<AssociationView>();
    }

    @Override
    public void applyChanges() {
        this.specificationView.applyChanges();
        MainFrame.getInstance().update();
    }
}

