/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.diagram;

import clews.MainFrame;
import clews.data.Class;
import clews.env.Environment;
import clews.env.Utils;
import clews.gui.PanelDropTarget;
import clews.gui.diagram.AnyDiagram;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;

public class DiagramPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 2502690645254790583L;
    protected AnyDiagram diagram;
    protected RenderingHints renderHints;
    protected boolean controlDown;
    protected int lastx;
    protected int lasty;
    protected Point selectionUpper;
    protected Point selectionLower;
    protected PanelDropTarget dt;
    protected MainFrame mainFrame;

    public DiagramPanel(MainFrame mf) {
        this.mainFrame = mf;
        this.dt = new PanelDropTarget(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.isControlDown() != Environment.IS_CONTROL_DOWN) {
                    Environment.IS_CONTROL_DOWN = e.isControlDown();
                    DiagramPanel.this.controlDownChanged();
                }
                if (e.isControlDown() && e.getKeyCode() == 80) {
                    DiagramPanel.this.export("d:\\fig.eps", true);
                }
                return false;
            }
        });
        this.setBackground(Environment.DIAGRAM_BACKGROUND);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public void changeSelectedDiagram(AnyDiagram newDiagram) {
        if (this.diagram != null) {
            this.removeMouseListener(this.diagram);
            this.removeMouseMotionListener(this.diagram);
        }
        this.diagram = newDiagram;
        if (this.diagram != null) {
            this.addMouseListener(this.diagram);
            this.addMouseMotionListener(this.diagram);
        }
        this.updateUI();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.diagram.hasSelection() && !this.diagram.isOverObject()) {
            this.diagram.clearDragList();
            if (e.getButton() == 1) {
                this.selectionUpper = e.getPoint();
            } else {
                this.diagram.getInverseTransform().transform(e.getPoint(), e.getPoint());
                this.setBackground(Environment.DIAGRAM_SELECTED_BACKGROUND);
                this.lastx = (int)this.diagram.getTransform().getTranslateX() - e.getX();
                this.lasty = (int)this.diagram.getTransform().getTranslateY() - e.getY();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.diagram.hasSelection() && !this.diagram.isOverObject()) {
            if (this.selectionUpper != null) {
                this.selectionLower = e.getPoint();
            } else {
                this.diagram.getInverseTransform().transform(e.getPoint(), e.getPoint());
                double s = this.diagram.getTransform().getScaleX();
                this.diagram.getTransform().setToTranslation(this.lastx + e.getX(), this.lasty + e.getY());
                this.diagram.getTransform().scale(s, s);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setBackground(Environment.DIAGRAM_BACKGROUND);
        if (this.selectionLower != null && this.selectionUpper != null) {
            Point2D sl = this.diagram.getInverseTransform().transform(new Point2D.Double(this.selectionLower.x, this.selectionLower.y), null);
            Point2D su = this.diagram.getInverseTransform().transform(new Point2D.Double(this.selectionUpper.x, this.selectionUpper.y), null);
            Rectangle r = new Rectangle((int)Math.min(su.getX(), sl.getX()), (int)Math.min(su.getY(), sl.getY()), (int)Math.abs(sl.getX() - su.getX()), (int)Math.abs(su.getY() - sl.getY()));
            this.diagram.select(r);
        }
        this.selectionUpper = null;
        this.selectionLower = null;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    protected void controlDownChanged() {
        this.diagram.clearSelection();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.renderHints);
        this.drawDiagram(g2);
    }

    public boolean export(String filename, boolean screen) {
        try {
            Dimension dim = this.diagram.setUpPrint();
            if (screen) {
                dim = Environment.CURRENT_DIALOG != null ? Environment.CURRENT_DIALOG.getSize() : MainFrame.getInstance().getSize();
            }
            if (!Utils.getExtension(filename).equals("eps")) {
                BufferedImage bi = new BufferedImage(dim.width, dim.height, 2);
                Graphics2D g2 = bi.createGraphics();
                g2.setRenderingHints(this.renderHints);
                g2.setColor(Color.WHITE);
                System.out.println(dim);
                g2.fillRect(0, 0, dim.width, dim.height);
                if (screen) {
                    MainFrame.getInstance().paint(g2);
                } else {
                    this.drawDiagram(g2, true);
                }
                File outputfile = new File(filename);
                outputfile.createNewFile();
                ImageIO.write((RenderedImage)bi, Utils.getExtension(filename), outputfile);
            } else {
                EpsGraphics g2 = new EpsGraphics("Clews Diagram Export", (OutputStream)new FileOutputStream(new File(filename)), 0, 0, dim.width, dim.height, ColorMode.COLOR_RGB);
                g2.setRenderingHints((Map)this.renderHints);
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, dim.width, dim.height);
                if (screen) {
                    if (Environment.CURRENT_DIALOG != null) {
                        Environment.CURRENT_DIALOG.paint((Graphics)g2);
                    } else {
                        MainFrame.getInstance().paint((Graphics)g2);
                    }
                } else {
                    this.drawDiagram((Graphics2D)g2, true);
                }
                g2.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void drawDiagram(Graphics2D g2) {
        this.drawDiagram(g2, false);
    }

    public void drawDiagram(Graphics2D g2, boolean isPrinting) {
        if (this.diagram != null) {
            AffineTransform save = g2.getTransform();
            if (!isPrinting) {
                g2.transform(this.diagram.getTransform());
            } else {
                g2.transform(this.diagram.getPrintShift());
            }
            this.diagram.draw(g2);
            g2.setTransform(save);
        }
        if (!isPrinting) {
            this.drawSelectionRect(g2);
        }
    }

    public void drawSelectionRect(Graphics2D g2) {
        if (this.selectionLower != null && this.selectionUpper != null) {
            g2.setColor(Color.BLUE);
            g2.setComposite(AlphaComposite.getInstance(3, Environment.DIAGRAM_SELECTION_ALPHA));
            Dimension dim = new Dimension(Math.abs(this.selectionLower.x - this.selectionUpper.x), Math.abs(this.selectionLower.y - this.selectionUpper.y));
            Rectangle rect = new Rectangle(new Point(Math.min(this.selectionLower.x, this.selectionUpper.x), Math.min(this.selectionLower.y, this.selectionUpper.y)), dim);
            g2.fill(rect);
            g2.draw(rect);
            g2.setComposite(AlphaComposite.getInstance(3, Environment.DIAGRAM_SELECTION_ALPHA));
        }
    }

    public void classDroped(Class c, Point p) {
        this.mainFrame.getDomain().classDroped(c, p);
    }

    public AnyDiagram getDiagram() {
        return this.diagram;
    }

    public void resetView() {
        if (this.diagram != null) {
            this.diagram.setTransform(AffineTransform.getScaleInstance(1.0, 1.0));
            this.diagram.getTransform().setToTranslation(0.0, 0.0);
        }
    }

    public void zoomIn() {
        if (this.diagram != null) {
            this.diagram.getTransform().scale(Environment.USER_ZOOM_IN, Environment.USER_ZOOM_IN);
        }
    }

    public void zoomOut() {
        if (this.diagram != null) {
            this.diagram.getTransform().scale(Environment.USER_ZOOM_OUT, Environment.USER_ZOOM_OUT);
        }
    }

    public void moveLeft() {
        this.moveView(-Environment.USER_TRANSLATION, 0.0);
    }

    public void moveRight() {
        this.moveView(Environment.USER_TRANSLATION, 0.0);
    }

    public void moveUp() {
        this.moveView(0.0, -Environment.USER_TRANSLATION);
    }

    public void moveDown() {
        this.moveView(0.0, Environment.USER_TRANSLATION);
    }

    protected void moveView(double x, double y) {
        if (this.diagram != null) {
            this.diagram.getTransform().translate(x, y);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
        this.repaint();
    }
}

