/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.diagram;

import clews.env.Environment;
import clews.gui.diagram.AnyDiagram;
import clews.gui.diagram.DiagramPanel;
import clews.gui.view.PickableObject;
import clews.gui.view.SelectableObject;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;

public abstract class Diagram<P extends PickableObject, S extends SelectableObject>
implements AnyDiagram {
    protected ArrayList<PickableObject> dragList;
    protected PickableObject drag;
    protected PickableObject selection;
    protected DiagramPanel panel;
    protected SelectableObject overObject;
    protected boolean hasSelection;
    protected boolean repaintRequest;
    protected Point2D mp;
    protected JWindow toolTip;
    protected JLabel toolTipLabel;
    protected boolean hovering;
    protected AffineTransform viewTransform = new AffineTransform();
    protected AffineTransform printShift = new AffineTransform();

    public Diagram(DiagramPanel dp) {
        this.panel = dp;
        this.hasSelection = false;
        this.drag = null;
        this.repaintRequest = false;
        this.mp = new Point();
        this.dragList = new ArrayList();
        this.toolTip = null;
    }

    public abstract ArrayList<P> getPickableObjects();

    public abstract ArrayList<S> getSelectableObjects();

    @Override
    public void draw(Graphics2D g) {
        if (this.drag != null) {
            this.drag.draw(g);
        }
    }

    @Override
    public boolean hasSelection() {
        return this.hasSelection;
    }

    @Override
    public boolean isOverObject() {
        return this.overObject != null;
    }

    @Override
    public void clearDragList() {
        for (PickableObject po : this.dragList) {
            po.unmark();
        }
        this.dragList.clear();
    }

    protected void initToolTip() {
        this.toolTipLabel = new JLabel(" ");
        this.toolTipLabel.setOpaque(true);
        this.toolTipLabel.setBackground(UIManager.getColor("ToolTip.background"));
        this.toolTip = new JWindow(new Frame());
        this.toolTip.getContentPane().add(this.toolTipLabel);
    }

    @Override
    public void select(Rectangle r) {
        this.dragList.clear();
        for (PickableObject po : this.getPickableObjects()) {
            if (!r.contains(po.getBounds())) continue;
            this.dragList.add(po);
            po.mark();
        }
    }

    public P getPickableForPos(Point2D p) {
        for (PickableObject po : this.getPickableObjects()) {
            if (!po.contains(p)) continue;
            return (P)po;
        }
        return null;
    }

    @Override
    public void clearSelection() {
        this.hasSelection = false;
        if (this.selection != null) {
            this.selection.setSelected(false);
            this.selection = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() > 1 && this.overObject != null) {
            this.overObject.doubleClicked(e.getPoint());
        }
        if (e.getButton() == 3 && this.overObject != null) {
            this.overObject.rightClicked(e.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public abstract void connect(PickableObject var1, PickableObject var2);

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.toolTip != null) {
            this.toolTip.setVisible(false);
        }
        if (e.getButton() == 1) {
            this.transformMousePos(e);
            if (Environment.IS_CONTROL_DOWN) {
                P po = this.getPickableForPos(this.mp);
                if (po != null) {
                    if (this.selection == null) {
                        this.selection = po;
                        this.selection.setSelected(true);
                    } else {
                        this.connect(this.selection, (PickableObject)po);
                        this.clearSelection();
                    }
                }
            } else {
                this.selection = null;
                this.drag = this.getPickableForPos(this.mp);
                if (this.drag != null) {
                    if (!this.dragList.contains(this.drag)) {
                        for (PickableObject po : this.dragList) {
                            po.unmark();
                        }
                        this.dragList.clear();
                    }
                    this.hasSelection = true;
                    this.drag.clicked(this.mp);
                    for (PickableObject po : this.dragList) {
                        po.clicked(this.mp);
                    }
                }
            }
        }
    }

    public void checkToolTip(PickableObject po, Point p) {
    }

    public void clearToolTip() {
        if (!this.hovering && this.toolTip != null && this.toolTip.isVisible()) {
            this.toolTip.setVisible(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.drag != null) {
            this.hasSelection = false;
            this.drag.release();
            for (PickableObject po : this.dragList) {
                po.release();
            }
            this.dragList.clear();
        }
        if (!Environment.IS_CONTROL_DOWN) {
            this.selection = null;
        }
        this.drag = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag != null) {
            this.transformMousePos(e);
            this.drag.updateLocation(this.mp);
            for (PickableObject po : this.dragList) {
                po.updateLocation(this.mp);
            }
            this.repaintRequest = true;
        }
        if (!Environment.IS_CONTROL_DOWN) {
            this.selection = null;
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.transformMousePos(e);
        this.overObject = null;
        this.hovering = false;
        for (PickableObject po : this.getPickableObjects()) {
            if (po.contains(this.mp)) {
                this.repaintRequest |= po.setOver(true);
                if (this.overObject == null) {
                    this.overObject = po;
                }
                this.checkToolTip(po, e.getPoint());
                continue;
            }
            if (this.dragList.contains(po)) continue;
            this.repaintRequest |= po.setOver(false);
        }
        this.clearToolTip();
        for (SelectableObject so : this.getSelectableObjects()) {
            if (this.overObject == null && so.contains(this.mp)) {
                this.repaintRequest |= so.setOver(true);
                this.overObject = so;
                continue;
            }
            this.repaintRequest |= so.setOver(false);
        }
        this.repaint();
    }

    @Override
    public AffineTransform getPrintShift() {
        return this.printShift;
    }

    @Override
    public Dimension setUpPrint() {
        int miny = Integer.MAX_VALUE;
        int minx = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        int maxx = Integer.MIN_VALUE;
        for (SelectableObject cv : this.getPickableObjects()) {
            minx = Math.min(minx, cv.getPrintBounds().x);
            miny = Math.min(miny, cv.getPrintBounds().y);
            maxx = Math.max(maxx, cv.getPrintBounds().x + cv.getPrintBounds().width);
            maxy = Math.max(maxy, cv.getPrintBounds().y + cv.getPrintBounds().height);
        }
        for (SelectableObject cv : this.getSelectableObjects()) {
            minx = Math.min(minx, cv.getPrintBounds().x);
            miny = Math.min(miny, cv.getPrintBounds().y);
            maxx = Math.max(maxx, cv.getPrintBounds().x + cv.getPrintBounds().width);
            maxy = Math.max(maxy, cv.getPrintBounds().y + cv.getPrintBounds().height);
        }
        this.printShift = AffineTransform.getTranslateInstance(-minx + Environment.PRINT_SPACING, -miny + Environment.PRINT_SPACING);
        return new Dimension(maxx - minx + 2 * Environment.PRINT_SPACING, maxy - miny + 2 * Environment.PRINT_SPACING);
    }

    public Point2D transformMousePos(MouseEvent e) {
        this.getInverseTransform().transform(e.getPoint(), this.mp);
        return this.mp;
    }

    public void setRepaint() {
        this.repaintRequest = true;
    }

    public void repaint() {
        if (this.repaintRequest) {
            this.panel.repaint();
            this.repaintRequest = false;
        }
    }

    @Override
    public AffineTransform getTransform() {
        return this.viewTransform;
    }

    @Override
    public void setTransform(AffineTransform at) {
        this.viewTransform = at;
    }

    public void setTransformParameter(double scale, double transx, double transy) {
        this.viewTransform = AffineTransform.getTranslateInstance(transx, transy);
        this.viewTransform.scale(scale, scale);
    }

    @Override
    public AffineTransform getInverseTransform() {
        try {
            return this.getTransform().createInverse();
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

