/*
 * Decompiled with CFR 0.152.
 */
package clews.gui.diagram;

import clews.History;
import clews.MainFrame;
import clews.gui.diagram.Diagram;
import clews.gui.view.ConfigurationView;
import clews.gui.view.InstanceView;
import clews.gui.view.LinkView;
import clews.gui.view.PickableObject;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ConfigurationDiagram
extends Diagram<InstanceView, LinkView> {
    protected ConfigurationView configurationView;

    public ConfigurationDiagram(ConfigurationView cv) {
        super(MainFrame.getInstance().getDiagramPanel());
        this.configurationView = cv;
        this.initToolTip();
    }

    public ConfigurationView getConfigurationView() {
        return this.configurationView;
    }

    @Override
    public String getName() {
        return this.configurationView.getConfiguration().getName();
    }

    @Override
    public void connect(PickableObject po1, PickableObject po2) {
        MainFrame.getInstance().getDomain().getHistory().addUndo(null, History.Operation.ADD, "Link added");
        LinkView lv = this.configurationView.addNewLinkView(this.configurationView.getConfiguration().link(((InstanceView)po1).getInstance(), ((InstanceView)po2).getInstance()));
        this.applyChanges();
    }

    @Override
    public void checkToolTip(PickableObject po, Point p) {
        InstanceView iv;
        if (po instanceof InstanceView && !(iv = (InstanceView)po).getInstance().isConsistent()) {
            if (!this.toolTip.isVisible()) {
                this.toolTipLabel.setText(iv.getInstance().reportConflicts());
                this.toolTip.pack();
                this.toolTip.setVisible(true);
            }
            this.hovering = true;
            SwingUtilities.convertPointToScreen(p, this.panel);
            this.toolTip.setLocation(p.x + 5, p.y - this.toolTip.getHeight() - 5);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.configurationView != null) {
            this.configurationView.draw(g);
        }
        super.draw(g);
    }

    @Override
    public ArrayList<InstanceView> getPickableObjects() {
        return this.configurationView.getInstances();
    }

    @Override
    public ArrayList<LinkView> getSelectableObjects() {
        return this.configurationView.getLinks();
    }

    @Override
    public void applyChanges() {
        this.configurationView.applyChanges();
        MainFrame.getInstance().update();
    }
}

