/*
 * Decompiled with CFR 0.152.
 */
package clews.gui;

import clews.MainFrame;
import clews.data.Class;
import clews.gui.DomainTree;
import clews.gui.DomainTreeModel;
import clews.gui.TransferableTreeItem;
import clews.gui.diagram.ConfigurationDiagram;
import clews.gui.diagram.SpecificationDiagram;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.tree.TreePath;

class TreeDragSource
implements DragSourceListener,
DragGestureListener {
    protected DragSource source;
    protected DragGestureRecognizer recognizer;
    protected DomainTree sourceTree;

    public TreeDragSource(DomainTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent arg0) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent arg0) {
    }

    @Override
    public void dragExit(DragSourceEvent arg0) {
    }

    @Override
    public void dragOver(DragSourceDragEvent arg0) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent arg0) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TransferableTreeItem t;
        TreePath path = this.sourceTree.getSelectionPath();
        if (path.getLastPathComponent() instanceof Class) {
            t = new TransferableTreeItem(path);
            if (MainFrame.getInstance().getDiagramPanel().getDiagram() instanceof ConfigurationDiagram) {
                this.source.startDrag(dge, DragSource.DefaultCopyDrop, t, this);
            }
        }
        if (path.getLastPathComponent().equals(((DomainTreeModel)this.sourceTree.getModel()).getClassGroup())) {
            t = new TransferableTreeItem(path);
            if (MainFrame.getInstance().getDiagramPanel().getDiagram() instanceof SpecificationDiagram) {
                this.source.startDrag(dge, DragSource.DefaultCopyDrop, t, this);
            }
        }
    }
}

