/*
 * Decompiled with CFR 0.152.
 */
package clews.gui;

import clews.MainFrame;
import clews.data.Class;
import clews.gui.TransferableTreeItem;
import clews.gui.diagram.DiagramPanel;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class PanelDropTarget
implements DropTargetListener {
    protected DiagramPanel targetPanel;
    DropTarget target;

    public PanelDropTarget(DiagramPanel panel) {
        this.targetPanel = panel;
        this.target = new DropTarget(this.targetPanel, this);
    }

    public Class extractClass(Transferable t) {
        Class ret = null;
        try {
            TreePath tp;
            Object tmp = t.getTransferData(TransferableTreeItem.TREE_PATH_FLAVOR);
            if (tmp instanceof TreePath && (tp = MainFrame.getInstance().getDomainTree().getSelectionPath()).getLastPathComponent() instanceof Class) {
                ret = (Class)tp.getLastPathComponent();
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void doAccept(DropTargetDragEvent dtde) {
        if (dtde.getTransferable().isDataFlavorSupported(TransferableTreeItem.TREE_PATH_FLAVOR)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.doAccept(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.doAccept(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(dtde.getDropAction());
        Class c = this.extractClass(dtde.getTransferable());
        this.targetPanel.classDroped(c, dtde.getLocation());
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

