/*
 * Decompiled with CFR 0.152.
 */
package clews.gui;

import clews.Domain;
import clews.History;
import clews.MainFrame;
import clews.data.Association;
import clews.env.Environment;
import clews.export.DomainXMLExport;
import clews.export.DomainXMLImport;
import clews.export.SpecificationILPExport;
import clews.gui.CustomFileFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.javailp.OptType;
import net.sf.javailp.Result;

public class MainMenu
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = -2579293378832746912L;
    protected MainFrame mainFrame;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;

    public MainMenu(MainFrame mf) {
        this.mainFrame = mf;
        Entry[] entries = new Entry[]{new Entry(new Entry[]{new Entry("File"), new Entry("New", new FileNewListener()), new Entry("Open", new FileOpenListener()), new Entry(""), new Entry("Save", new FileSaveListener(false)), new Entry("Save as", new FileSaveListener(true)), new Entry(""), new Entry(new Entry[]{new Entry("Export"), new Entry("as PNG", new FileExportImageListener("png", false)), new Entry("as GIF", new FileExportImageListener("gif", false)), new Entry("as EPS", new FileExportImageListener("eps", false))}), new Entry(new Entry[]{new Entry("Export Screen"), new Entry("as PNG", new FileExportImageListener("png", true)), new Entry("as GIF", new FileExportImageListener("gif", true)), new Entry("as EPS", new FileExportImageListener("eps", true))}), new Entry(new Entry[]{new Entry("Import"), new Entry("Existing Specification", new FileImportSpecifciation()), new Entry("Existing Configuration", new FileImportConfiguration())}), new Entry(""), new Entry("Exit", new FileExitListener())}), new Entry(new Entry[]{new Entry("Edit"), new Entry("Undo", new EditUndoListener()), new Entry("Redo", new EditRedoListener())}), new Entry(new Entry[]{new Entry("Domain"), new Entry("New Class", new DomainNewClassListener()), new Entry("New Constraint", new DomainNewConstraintListener()), new Entry(""), new Entry("New Configuration", new DomainNewConfigurationListener()), new Entry("New Configuration from minimal model", new DomainNewConfigurationMinimalListener()), new Entry("Extend configuration to instance", new DomainExtendListener()), new Entry(""), new Entry("Check manually", new DomainCheckListener())}), new Entry(new Entry[]{new Entry("View"), new Entry("All Details", new ViewDetailsListener(Environment.ViewDetails.ALL)), new Entry("Some Details", new ViewDetailsListener(Environment.ViewDetails.SOME)), new Entry("No Details", new ViewDetailsListener(Environment.ViewDetails.NO)), new Entry("Custom Details", new ViewDetailsListener(Environment.ViewDetails.NO)), new Entry(""), new Entry("Reset", new ViewResetListener()), new Entry(""), new Entry("Zoom In", new ViewZoomInListener()), new Entry("Zoom Out", new ViewZoomOutListener()), new Entry(""), new Entry("Move Left", new ViewMoveLeftListener()), new Entry("Move Right", new ViewMoveRightListener()), new Entry("Move Up", new ViewMoveUpListener()), new Entry("Move Down", new ViewMoveDownListener())}), new Entry(new Entry[]{new Entry("Info"), new Entry("About CLEWS", new InfoClewsListener())})};
        this.createMenu(entries, null);
        this.undoItem = this.getMenu(1).getItem(0);
        this.redoItem = this.getMenu(1).getItem(1);
        this.refreshUnRedo();
    }

    public void createMenu(Entry[] entries, JMenu parent) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i].children == null) {
                if (i > 0) {
                    if (entries[i].label.equals("")) {
                        parent.addSeparator();
                    } else {
                        JMenuItem item = new JMenuItem(entries[i].label);
                        item.setIcon(entries[i].icon);
                        item.addActionListener(entries[i].listener);
                        item.addActionListener(this);
                        parent.add(item);
                    }
                }
            } else {
                JMenu curMenu = new JMenu(entries[i].children[0].label);
                this.createMenu(entries[i].children, curMenu);
                if (parent == null) {
                    this.add(curMenu);
                } else {
                    parent.add(curMenu);
                }
            }
            ++i;
        }
    }

    public void refreshUnRedo() {
        this.undoItem.setText("Undo");
        this.redoItem.setText("Redo");
        if (this.mainFrame.getDomain() != null) {
            History h = this.mainFrame.getDomain().getHistory();
            this.undoItem.setEnabled(h.getUndoStack().size() > 0);
            if (this.undoItem.isEnabled()) {
                this.undoItem.setText("Undo " + h.getUndoStack().peek());
            }
            this.redoItem.setEnabled(h.getRedoStack().size() > 0);
            if (this.redoItem.isEnabled()) {
                this.redoItem.setText("Redo " + h.getRedoStack().peek());
            }
        } else {
            this.undoItem.setEnabled(false);
            this.redoItem.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.mainFrame != null) {
            this.mainFrame.repaint();
        }
    }

    class DomainCheckListener
    implements ActionListener {
        DomainCheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SpecificationILPExport ilp = new SpecificationILPExport(MainMenu.this.mainFrame.getDomain().getSpecification());
            ilp.export();
            ilp.setObjective(OptType.MIN);
            Result r = ilp.solve();
            ilp.printProblem();
            MainMenu.this.mainFrame.getTextOutput().setText(String.valueOf(MainMenu.this.mainFrame.getTextOutput().getText()) + "\nMIN Result: " + r);
            ilp.setObjective(OptType.MAX);
            r = ilp.solve();
            MainMenu.this.mainFrame.getTextOutput().setText(String.valueOf(MainMenu.this.mainFrame.getTextOutput().getText()) + "\nMAX Result: " + r);
        }
    }

    class DomainExtendListener
    implements ActionListener {
        DomainExtendListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().extendConfiguration();
        }
    }

    class DomainNewClassListener
    implements ActionListener {
        DomainNewClassListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().addNewClass();
        }
    }

    class DomainNewConfigurationListener
    implements ActionListener {
        DomainNewConfigurationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().addNewConfiguration();
        }
    }

    class DomainNewConfigurationMinimalListener
    implements ActionListener {
        DomainNewConfigurationMinimalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().addNewMinimalConfiguration();
        }
    }

    class DomainNewConstraintListener
    implements ActionListener {
        DomainNewConstraintListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().addNewConstraint();
        }
    }

    class EditRedoListener
    implements ActionListener {
        EditRedoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().getHistory().doRedo();
        }
    }

    class EditUndoListener
    implements ActionListener {
        EditUndoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().getHistory().doUndo();
        }
    }

    class Entry {
        public String label;
        public Icon icon;
        public ActionListener listener;
        public Entry[] children;

        public Entry(String l) {
            this(l, null, null);
        }

        public Entry(Entry[] entries) {
            this(null, null, null);
            this.children = entries;
        }

        public Entry(String l, ActionListener al) {
            this(l, al, null);
        }

        public Entry(String l, ActionListener al, Icon i) {
            this.label = l;
            this.listener = al;
            this.icon = i;
            this.children = null;
        }
    }

    class FileExitListener
    implements ActionListener {
        FileExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }
    }

    class FileExportImageListener
    implements ActionListener {
        protected String ending;
        protected boolean screen;

        public FileExportImageListener(String end, boolean s) {
            this.ending = end;
            this.screen = s;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser chooser = new JFileChooser();
            CustomFileFilter filter = new CustomFileFilter(new String[]{this.ending}, String.valueOf(this.ending.toUpperCase()) + " (*." + this.ending + ")");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(MainMenu.this.mainFrame);
            if (returnVal == 0) {
                String path = chooser.getSelectedFile().getAbsolutePath();
                if (!path.endsWith("." + this.ending)) {
                    path = String.valueOf(path) + "." + this.ending;
                }
                if (!MainMenu.this.mainFrame.getDiagramPanel().export(path, this.screen)) {
                    JOptionPane.showMessageDialog(MainMenu.this.mainFrame, "Exporting diagram to " + path + " caused an error", "Error while exporting file...", 0);
                } else {
                    MainMenu.this.mainFrame.setMessageText("Image exported in " + path);
                }
            }
        }
    }

    class FileImportConfiguration
    implements ActionListener {
        FileImportConfiguration() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }

    class FileImportSpecifciation
    implements ActionListener {
        FileImportSpecifciation() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }

    class FileNewListener
    implements ActionListener {
        FileNewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDomain().newDomain();
            MainMenu.this.mainFrame.getDomain().getHistory().clearUndoRedo();
        }
    }

    class FileOpenListener
    implements ActionListener {
        FileOpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser chooser = new JFileChooser();
            CustomFileFilter filter = new CustomFileFilter(new String[]{Environment.DOMAIN_ENDING}, "Clews Domains (*." + Environment.DOMAIN_ENDING + ")");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(MainMenu.this.mainFrame);
            if (returnVal == 0) {
                String path = chooser.getSelectedFile().getAbsolutePath();
                DomainXMLImport dxe = new DomainXMLImport();
                if (!(path.endsWith("." + Environment.DOMAIN_ENDING) && new File(path).exists() && dxe.loadFromDisk(path))) {
                    JOptionPane.showMessageDialog(MainMenu.this.mainFrame, String.valueOf(path) + " is not a valid Clews domain file", "Error while reading file...", 0);
                } else {
                    MainMenu.this.mainFrame.getDomain().getHistory().clearUndoRedo();
                    Domain d = MainMenu.this.mainFrame.getDomain();
                    d.newDomain(false);
                    d.setPath(path);
                    d.setConfigurations(dxe.getConfigurations());
                    d.setSpecification(dxe.getSpecification());
                    for (Association assoc : d.getSpecification().getAssociations()) {
                        if (assoc.getLeft().getConstrainedMin() == 0) {
                            assoc.getLeft().setConstrainedMin(assoc.getConstrainedMinLeft());
                        }
                        if (assoc.getLeft().getConstrainedMax() == 0) {
                            assoc.getLeft().setConstrainedMax(assoc.getConstrainedMaxLeft());
                        }
                        if (assoc.getRight().getConstrainedMin() == 0) {
                            assoc.getRight().setConstrainedMin(assoc.getConstrainedMinRight());
                        }
                        if (assoc.getRight().getConstrainedMax() != 0) continue;
                        assoc.getRight().setConstrainedMax(assoc.getConstrainedMaxRight());
                    }
                    MainMenu.this.mainFrame.setMessageText("Domain loaded from " + path);
                }
            }
        }
    }

    class FileSaveListener
    implements ActionListener {
        boolean forceDialog;

        public FileSaveListener(boolean fd) {
            this.forceDialog = fd;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String path = MainMenu.this.mainFrame.getDomain().getPath();
            if (this.forceDialog || path == null || path.contains(Environment.HISTORY_PATH)) {
                JFileChooser chooser = new JFileChooser();
                CustomFileFilter filter = new CustomFileFilter(new String[]{Environment.DOMAIN_ENDING}, "Clews Domains (*." + Environment.DOMAIN_ENDING + ")");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showSaveDialog(MainMenu.this.mainFrame);
                if (returnVal == 0) {
                    this.save(chooser.getSelectedFile().getAbsolutePath());
                }
            } else {
                this.save(path);
            }
            MainMenu.this.mainFrame.getDomain().getHistory().clearUndoRedo();
        }

        public void save(String path) {
            DomainXMLExport dxe;
            if (!path.endsWith("." + Environment.DOMAIN_ENDING)) {
                path = String.valueOf(path) + "." + Environment.DOMAIN_ENDING;
            }
            if ((dxe = new DomainXMLExport(MainFrame.getInstance().getDomain())).saveToDisk(path)) {
                MainMenu.this.mainFrame.setMessageText("Domain saved in " + path);
            } else {
                MainMenu.this.mainFrame.setMessageText("Error while saving domain");
            }
        }
    }

    class InfoClewsListener
    implements ActionListener {
        InfoClewsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JOptionPane.showMessageDialog(MainMenu.this.mainFrame, Environment.clewsversion);
            System.out.println(Environment.clewsversion);
        }
    }

    class ViewDetailsListener
    implements ActionListener {
        Environment.ViewDetails details;

        public ViewDetailsListener(Environment.ViewDetails vd) {
            this.details = vd;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Environment.VIEW_DETAILS = this.details;
        }
    }

    class ViewMoveDownListener
    implements ActionListener {
        ViewMoveDownListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().moveDown();
        }
    }

    class ViewMoveLeftListener
    implements ActionListener {
        ViewMoveLeftListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().moveLeft();
        }
    }

    class ViewMoveRightListener
    implements ActionListener {
        ViewMoveRightListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().moveRight();
        }
    }

    class ViewMoveUpListener
    implements ActionListener {
        ViewMoveUpListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().moveUp();
        }
    }

    class ViewResetListener
    implements ActionListener {
        ViewResetListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().resetView();
        }
    }

    class ViewZoomInListener
    implements ActionListener {
        ViewZoomInListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().zoomIn();
        }
    }

    class ViewZoomOutListener
    implements ActionListener {
        ViewZoomOutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MainMenu.this.mainFrame.getDiagramPanel().zoomOut();
        }
    }
}

