/*
 * Decompiled with CFR 0.152.
 */
package clews.gui;

import clews.Domain;
import clews.data.Configuration;
import clews.data.Specification;
import java.util.ArrayList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DomainTreeModel
implements TreeModel {
    protected Domain domain;
    protected String root = "Domain";
    protected ArrayList<String> groups;

    public DomainTreeModel(Domain d) {
        this.domain = d;
        this.groups = new ArrayList();
        this.groups.add("Specification");
        this.groups.add(this.getClassGroup());
        this.groups.add("Associations");
        this.groups.add("Constraints");
        this.groups.add("Configurations");
    }

    public Specification getSpecification() {
        return this.domain.getSpecification();
    }

    public ArrayList<Configuration> getConfigurations() {
        return this.domain.getConfigurations();
    }

    public String getClassGroup() {
        return "Classes";
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent.toString().equals(this.root)) {
            return this.groups.get(index);
        }
        int idx = this.groups.indexOf(parent);
        switch (idx) {
            case 1: {
                return this.domain.getSpecification().getClasses().get(index);
            }
            case 2: {
                return this.domain.getSpecification().getAssociations().get(index);
            }
            case 3: {
                return this.domain.getSpecification().getConstraints().get(index);
            }
            case 4: {
                return this.domain.getConfigurations().get(index);
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent.toString().equals(this.root)) {
            return this.groups.size();
        }
        int idx = this.groups.indexOf(parent);
        switch (idx) {
            case 1: {
                return this.domain.getSpecification().getClasses().size();
            }
            case 2: {
                return this.domain.getSpecification().getAssociations().size();
            }
            case 3: {
                return this.domain.getSpecification().getConstraints().size();
            }
            case 4: {
                return this.domain.getConfigurations().size();
            }
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent.toString().equals(this.root)) {
            return this.groups.indexOf(child);
        }
        int idx = this.groups.indexOf(parent);
        switch (idx) {
            case 1: {
                return this.domain.getSpecification().getClasses().indexOf(child);
            }
            case 2: {
                return this.domain.getSpecification().getAssociations().indexOf(child);
            }
            case 3: {
                return this.domain.getSpecification().getConstraints().indexOf(child);
            }
            case 4: {
                return this.domain.getConfigurations().indexOf(child);
            }
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node.toString().equals(this.root)) {
            return false;
        }
        if (this.groups.indexOf(node) == 0) {
            return true;
        }
        return this.groups.indexOf(node) == -1;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

