/*
 * Decompiled with CFR 0.152.
 */
package clews.gui;

import clews.MainFrame;
import clews.data.Association;
import clews.data.Class;
import clews.data.Configuration;
import clews.data.Constraint;
import clews.gui.DomainTreeModel;
import clews.gui.TreeDragSource;
import clews.gui.view.AssociationView;
import clews.gui.view.ClassView;
import clews.gui.view.ConfigurationView;
import clews.gui.view.ConstraintView;
import clews.gui.view.SpecificationView;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DomainTree
extends JTree
implements MouseListener {
    private static final long serialVersionUID = 6855480194003030728L;
    protected TreePath rootSelPath;
    protected TreeDragSource ds;
    protected MainFrame mainFrame;

    public DomainTree(MainFrame mf) {
        this.mainFrame = mf;
        this.addMouseListener(this);
        this.ds = new TreeDragSource(this, 1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        this.rootSelPath = null;
        if (selRow != -1 && e.getClickCount() != 1 && e.getClickCount() == 2) {
            if (selPath.getLastPathComponent() instanceof Configuration) {
                this.mainFrame.getDiagramPanel().changeSelectedDiagram(((ConfigurationView)((Configuration)selPath.getLastPathComponent()).getView()).getDiagram());
                this.mainFrame.getDiagramPanel().repaint();
                this.mainFrame.getDiagramPanel().updateUI();
                this.mainFrame.getDiagramPanel().setVisible(true);
            }
            if (selPath.getLastPathComponent() instanceof Class) {
                ((ClassView)((Class)selPath.getLastPathComponent()).getView()).edit();
            }
            if (selPath.getLastPathComponent() instanceof Association) {
                ((AssociationView)((Association)selPath.getLastPathComponent()).getView()).edit();
            }
            if (selPath.getLastPathComponent() instanceof Constraint) {
                ((ConstraintView)((Constraint)selPath.getLastPathComponent()).getView()).edit();
            }
            ((DomainTreeModel)this.getModel()).getSpecification().applyChanges();
            if (selRow == 1) {
                this.mainFrame.getDiagramPanel().changeSelectedDiagram(((SpecificationView)this.mainFrame.getDomain().getSpecification().getView()).getDiagram());
                this.rootSelPath = selPath;
                this.mainFrame.getDiagramPanel().repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

