/*
 * Decompiled with CFR 0.152.
 */
package clews.gui;

import java.io.File;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class CustomFileFilter
extends FileFilter {
    protected Hashtable<String, String> extensions = new Hashtable();
    protected String description;

    public CustomFileFilter(String[] ext, String desc) {
        int i = 0;
        while (i < ext.length) {
            this.extensions.put(ext[i], ext[i]);
            ++i;
        }
        this.description = desc;
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.extensions.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

