/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.data.Association;
import clews.data.AssociationAttribute;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.Constraint;
import clews.data.DataObject;
import clews.data.Specification;
import clews.gui.view.ClassView;
import clews.gui.view.ConstraintView;
import clews.gui.view.SpecificationView;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class SpecificationXMLImport {
    protected Specification specification;
    protected SpecificationView specificationView;
    protected ArrayList<AssociationEnd> ends;
    protected String associationName;
    protected int associationId;
    protected Constraint constraint;
    protected Class currentClass;

    public Specification loadFromDisk(String path) {
        this.specification = null;
        System.out.println("Load File from Disk!!!! - SpecificationXMLImport");
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            DiagramSaxParser sax = new DiagramSaxParser();
            sax.setParent(reader);
            sax.parse(path);
            this.setIds();
            this.specification.applyChanges();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return this.specification;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    protected void setIds() {
        int max = Integer.MIN_VALUE;
        for (Class clazz : this.specification.getClasses()) {
            max = Math.max(max, clazz.getId());
        }
        System.out.println("Die maximale ID ist " + max);
        DataObject.setId(Class.class, max);
        max = Integer.MIN_VALUE;
        for (Association association : this.specification.getAssociations()) {
            max = Math.max(max, association.getId());
        }
        DataObject.setId(Association.class, max);
        max = Integer.MIN_VALUE;
        for (Constraint constraint : this.specification.getConstraints()) {
            max = Math.max(max, constraint.getId());
        }
        DataObject.setId(Constraint.class, max);
    }

    class DiagramSaxParser
    extends XMLFilterImpl {
        DiagramSaxParser() {
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
            if (localName.equals("specification")) {
                SpecificationXMLImport.this.specification = new Specification();
                SpecificationXMLImport.this.specificationView = new SpecificationView(SpecificationXMLImport.this.specification);
                SpecificationXMLImport.this.specification.setView(SpecificationXMLImport.this.specificationView);
                if (atts.getIndex("scale") != -1) {
                    SpecificationXMLImport.this.specificationView.getDiagram().setTransformParameter(Double.parseDouble(atts.getValue("scale")), Double.parseDouble(atts.getValue("transx")), Double.parseDouble(atts.getValue("transy")));
                }
            } else if (localName.equals("class")) {
                SpecificationXMLImport.this.currentClass = SpecificationXMLImport.this.specification.addNewClass(Integer.parseInt(atts.getValue("id")));
                SpecificationXMLImport.this.currentClass.setName(atts.getValue("name"));
                SpecificationXMLImport.this.currentClass.setMinObj(Integer.parseInt(atts.getValue("minobj")));
                ClassView view = SpecificationXMLImport.this.specificationView.addNewClassView(SpecificationXMLImport.this.currentClass);
                view.setLocation(Integer.parseInt(atts.getValue("x")), Integer.parseInt(atts.getValue("y")));
                int w = Integer.parseInt(atts.getValue("width"));
                int h = Integer.parseInt(atts.getValue("height"));
                if (w == 0) {
                    w = 115;
                }
                if (h == 0) {
                    h = 115;
                }
                view.getBounds().setSize(w, h);
                try {
                    SpecificationXMLImport.this.currentClass.setWeight(Integer.parseInt(atts.getValue("weight")));
                    SpecificationXMLImport.this.currentClass.setMaxObj(Integer.parseInt(atts.getValue("maxobj")));
                    SpecificationXMLImport.this.currentClass.setMinPartner(Integer.parseInt(atts.getValue("minpartner")));
                    SpecificationXMLImport.this.currentClass.setMaxPartner(Integer.parseInt(atts.getValue("maxpartner")));
                }
                catch (Exception exception) {}
            } else if (localName.equals("xorpartner")) {
                try {
                    SpecificationXMLImport.this.currentClass.setOrPartner(Integer.parseInt(atts.getValue("class")));
                }
                catch (Exception e) {
                    System.out.println("Fehler beim Einlesen " + e);
                }
            } else if (localName.equals("association")) {
                SpecificationXMLImport.this.ends = new ArrayList();
                SpecificationXMLImport.this.associationName = atts.getValue("name");
                SpecificationXMLImport.this.associationId = Integer.parseInt(atts.getValue("id"));
            } else if (localName.equals("associationend")) {
                SpecificationXMLImport.this.ends.add(new AssociationEnd(null, AssociationAttribute.valueOf(atts.getValue("type")), Integer.parseInt(atts.getValue("min")), Integer.parseInt(atts.getValue("max")), SpecificationXMLImport.this.specification.getClassById(Integer.parseInt(atts.getValue("assclass")))));
            } else if (localName.equals("constraint")) {
                SpecificationXMLImport.this.constraint = SpecificationXMLImport.this.specification.addNewConstraint();
                SpecificationXMLImport.this.constraint.setView(new ConstraintView(SpecificationXMLImport.this.constraint));
                SpecificationXMLImport.this.constraint.setId(Integer.parseInt(atts.getValue("id")));
                SpecificationXMLImport.this.constraint.setName(atts.getValue("name"));
                SpecificationXMLImport.this.constraint.setActive(Boolean.parseBoolean(atts.getValue("isactive")));
            } else if (localName.equals("constraintpartlhs")) {
                SpecificationXMLImport.this.constraint.addLhsPart(SpecificationXMLImport.this.specification.getAssociationById(Integer.parseInt(atts.getValue("association"))), Boolean.parseBoolean(atts.getValue("inv")));
            } else if (localName.equals("constraintpartrhs")) {
                SpecificationXMLImport.this.constraint.addRhsPart(SpecificationXMLImport.this.specification.getAssociationById(Integer.parseInt(atts.getValue("association"))), Boolean.parseBoolean(atts.getValue("inv")));
            }
            super.startElement(namespaceURI, localName.toLowerCase(), qualifiedName.toLowerCase(), atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            if (localName.equals("association")) {
                Association a = SpecificationXMLImport.this.specification.associate(SpecificationXMLImport.this.ends, false);
                a.setName(SpecificationXMLImport.this.associationName);
                a.setId(SpecificationXMLImport.this.associationId);
                SpecificationXMLImport.this.specificationView.addNewAssociationView(a);
            }
            super.endElement(namespaceURI, localName.toLowerCase(), qualifiedName.toLowerCase());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
        }
    }
}

