/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.data.Association;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.Constraint;
import clews.data.Specification;
import clews.export.XMLExport;
import clews.gui.view.ClassView;
import clews.gui.view.SpecificationView;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class SpecificationXMLExport
extends XMLExport {
    protected Specification specification;

    public SpecificationXMLExport(Specification s) {
        this.specification = s;
    }

    @Override
    public boolean saveToDisk(String path) {
        return this.save(path, false);
    }

    public boolean save(String path, boolean isTmp) {
        try {
            Element cur;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.doc.setXmlStandalone(true);
            Element main = this.doc.createElement("specification");
            this.specification.setPath(path);
            if (this.specification.getView() != null) {
                AffineTransform trafo = ((SpecificationView)this.specification.getView()).getDiagram().getTransform();
                this.addAttribute(main, "scale", "" + trafo.getScaleX());
                this.addAttribute(main, "transx", "" + trafo.getTranslateX());
                this.addAttribute(main, "transy", "" + trafo.getTranslateY());
            }
            this.doc.appendChild(main);
            ArrayList<Class> classes = this.specification.getClasses();
            for (Class c : classes) {
                Element cur2 = this.doc.createElement("class");
                ClassView view = (ClassView)c.getView();
                main.appendChild(cur2);
                this.addAttribute(cur2, "id", "" + c.getId());
                this.addAttribute(cur2, "name", c.getName());
                this.addAttribute(cur2, "minobj", "" + c.getMinObj());
                this.addAttribute(cur2, "weight", "" + c.getWeight());
                this.addAttribute(cur2, "maxobj", "" + c.getMaxObj());
                this.addAttribute(cur2, "minpartner", "" + c.getMinPartner());
                this.addAttribute(cur2, "maxpartner", "" + c.getMaxParnter());
                ArrayList<Integer> partner = c.getOrPartner();
                for (int cl : partner) {
                    Element part = this.doc.createElement("xorpartner");
                    this.addAttribute(part, "class", "" + cl);
                    cur2.appendChild(part);
                }
                Rectangle r = view != null ? view.getBounds() : new Rectangle();
                this.addAttribute(cur2, "x", "" + r.x);
                this.addAttribute(cur2, "y", "" + r.y);
                this.addAttribute(cur2, "width", "" + r.width);
                this.addAttribute(cur2, "height", "" + r.height);
            }
            ArrayList<Association> assocs = this.specification.getAssociations();
            for (Association a : assocs) {
                cur = this.doc.createElement("association");
                this.addAttribute(cur, "name", a.getName());
                this.addAttribute(cur, "id", "" + a.getId());
                main.appendChild(cur);
                for (AssociationEnd e : a.getEnds()) {
                    Element end = this.doc.createElement("associationend");
                    this.addAttribute(end, "assclass", "" + e.assclass.getId());
                    this.addAttribute(end, "type", "" + (Object)((Object)e.type));
                    this.addAttribute(end, "min", "" + e.getMin());
                    this.addAttribute(end, "max", "" + e.getMax());
                    cur.appendChild(end);
                }
            }
            for (Constraint c : this.specification.getConstraints()) {
                Element part;
                cur = this.doc.createElement("constraint");
                this.addAttribute(cur, "id", "" + c.getId());
                this.addAttribute(cur, "name", c.getName());
                this.addAttribute(cur, "isactive", "" + c.isActive());
                main.appendChild(cur);
                for (Constraint.ConstraintPart cp : c.getLhs()) {
                    part = this.doc.createElement("constraintpartlhs");
                    this.addAttribute(part, "association", "" + cp.association.getId());
                    this.addAttribute(part, "inv", "" + cp.inv);
                    cur.appendChild(part);
                }
                for (Constraint.ConstraintPart cp : c.getRhs()) {
                    part = this.doc.createElement("constraintpartrhs");
                    this.addAttribute(part, "association", "" + cp.association.getId());
                    this.addAttribute(part, "inv", "" + cp.inv);
                    cur.appendChild(part);
                }
            }
            this.toDisk(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

