/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.MainFrame;
import clews.data.Association;
import clews.data.AssociationAttribute;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.Specification;
import clews.env.Environment;
import java.util.HashMap;
import net.sf.javailp.Constraint;
import net.sf.javailp.Linear;
import net.sf.javailp.OptType;
import net.sf.javailp.Problem;
import net.sf.javailp.Result;
import net.sf.javailp.Solver;
import net.sf.javailp.SolverFactoryLpSolve;
import net.sf.javailp.VarType;

public class SpecificationILPExport {
    protected Specification diagram;
    protected Problem problem;
    protected Result intermediate;
    protected Result finalres;
    protected HashMap<Constraint, String> added;
    protected HashMap<Class, Integer> minObjects;

    public SpecificationILPExport(Specification d) {
        this(d, null);
    }

    public SpecificationILPExport(Specification d, HashMap<Class, Integer> min) {
        this.diagram = d;
        this.intermediate = null;
        this.finalres = null;
        this.minObjects = min;
        this.problem = new Problem();
    }

    public Problem export() {
        this.problem = new Problem();
        for (Class c : this.diagram.getClasses()) {
            this.transformClass(c);
        }
        for (Association a : this.diagram.getAssociations()) {
            this.transformAssociation(a);
        }
        return this.problem;
    }

    protected void transformClass(Class c) {
        Linear l;
        if (this.minObjects != null || c.getMinObj() > 0) {
            l = new Linear();
            l.add((Number)1, (Object)this.getName(c));
            if (this.minObjects != null) {
                this.problem.add(l, ">=", (Number)Math.max(c.getMinObj(), this.minObjects.get(c)));
            } else {
                this.problem.add(l, ">=", (Number)c.getMinObj());
            }
        }
        if (c.getMaxObj() != Environment.CARDINALITY_STAR) {
            l = new Linear();
            l.add((Number)1, (Object)this.getName(c));
            this.problem.add(l, "<=", (Number)c.getMaxObj());
        }
    }

    protected void addConditiondalInequalities() {
        this.added = new HashMap();
        OptType save = this.problem.getOptType();
        this.export();
        this.setObjective(save);
        this.intermediate = null;
    }

    public Result solve() {
        SolverFactoryLpSolve factory = new SolverFactoryLpSolve();
        factory.setParameter((Object)1, (Object)0);
        factory.setParameter((Object)0, (Object)100);
        this.finalres = null;
        try {
            int cc;
            do {
                cc = this.problem.getConstraintsCount();
                Solver solver = factory.get();
                this.finalres = this.intermediate = solver.solve(this.problem);
                this.addConditiondalInequalities();
            } while (cc != this.problem.getConstraintsCount());
        }
        catch (Exception e) {
            MainFrame.getInstance().getTextOutput().setText(String.valueOf(MainFrame.getInstance().getTextOutput().getText()) + "\n" + "No ILP-Solver found!");
        }
        return this.finalres;
    }

    protected Linear transformAssociation(Association assoc) {
        Linear linear = new Linear();
        AssociationAttribute tl = assoc.getTypeLeft();
        AssociationAttribute tr = assoc.getTypeRight();
        AssociationEnd l = assoc.getLeft();
        AssociationEnd r = assoc.getRight();
        if (tl == tr) {
            if (tl == AssociationAttribute.UNIQUE) {
                this.addUniqueUnique(l, r);
            } else if (tl == AssociationAttribute.NON_UNIQUE) {
                this.addNonUniqueNonUnique(l, r);
            } else if (tl == AssociationAttribute.ALL_SAME) {
                this.addAllSameAllSame(l, r);
            }
        } else if (tl == AssociationAttribute.UNIQUE) {
            if (tr == AssociationAttribute.NON_UNIQUE) {
                this.addNonUniqueUnique(r, l);
            } else if (tr == AssociationAttribute.ALL_SAME) {
                this.addAllSameUnique(r, l);
            }
        } else if (assoc.getTypeLeft() == AssociationAttribute.NON_UNIQUE) {
            if (tr == AssociationAttribute.UNIQUE) {
                this.addNonUniqueUnique(l, r);
            } else if (tr == AssociationAttribute.ALL_SAME) {
                this.addAllSameNonUnique(r, l);
            }
        } else if (assoc.getTypeLeft() == AssociationAttribute.ALL_SAME) {
            if (tr == AssociationAttribute.UNIQUE) {
                this.addAllSameUnique(l, r);
            } else if (tr == AssociationAttribute.NON_UNIQUE) {
                this.addAllSameNonUnique(l, r);
            }
        }
        return linear;
    }

    public void printProblem() {
        String text = "";
        for (Constraint c : this.problem.getConstraints()) {
            if (this.added.containsKey(c)) {
                text = String.valueOf(text) + this.added.get(c);
            }
            text = String.valueOf(text) + c + "\n";
        }
        MainFrame.getInstance().getTextOutput().setText(text);
    }

    protected String getName(AssociationEnd ae) {
        return this.getName(ae.assclass);
    }

    protected String getName(Class c) {
        return SpecificationILPExport.makeVar(c.getName());
    }

    public int getResultVal(Class c) {
        return this.finalres.get((Object)this.getName(c)).intValue();
    }

    public static String makeVar(String name) {
        return "|" + name + "|";
    }

    protected int getIntermediateObjects(AssociationEnd u) {
        if (this.intermediate != null) {
            return this.intermediate.get((Object)this.getName(u)).intValue();
        }
        return 0;
    }

    protected void addNonUnique(AssociationEnd u, AssociationEnd v) {
        if (v.getMax() != Environment.CARDINALITY_STAR) {
            Linear l = new Linear();
            l.add((Number)u.getMin(), (Object)this.getName(v));
            l.add((Number)(-v.getMax()), (Object)this.getName(u));
            this.problem.add(l, "<=", (Number)0);
        }
    }

    protected String getConditionalString(AssociationEnd u, int card) {
        return String.valueOf(this.getName(u)) + " > " + card + "   -->   ";
    }

    protected void addUnique(AssociationEnd u, AssociationEnd v) {
        if (this.getIntermediateObjects(u) > 0) {
            Linear l = new Linear();
            l.add((Number)1, (Object)this.getName(v));
            Constraint c = new Constraint(l, ">=", (Number)v.getMin());
            this.problem.add(c);
            this.added.put(c, this.getConditionalString(u, 0));
        }
    }

    protected void addNonUniqueNonUnique(AssociationEnd u, AssociationEnd v) {
        this.addNonUnique(u, v);
        this.addNonUnique(v, u);
    }

    protected void addUniqueUnique(AssociationEnd u, AssociationEnd v) {
        this.addNonUniqueNonUnique(u, v);
        this.addUnique(u, v);
        this.addUnique(v, u);
    }

    protected void addNonUniqueUnique(AssociationEnd u, AssociationEnd v) {
        this.addNonUnique(v, u);
        this.addUnique(u, v);
        if (u.getMin() > 0 && v.getMax() != Environment.CARDINALITY_STAR) {
            Linear l = new Linear();
            l.add((Number)1, (Object)this.getName(v));
            l.add((Number)(-v.getMax()), (Object)this.getName(u));
            this.problem.add(l, "<=", (Number)0);
        }
    }

    protected void addAllSameAllSame(AssociationEnd u, AssociationEnd v) {
        if (u.getMin() <= v.getMax() && v.getMin() <= u.getMax()) {
            Linear l;
            if (u.getMin() > 0) {
                l = new Linear();
                l.add((Number)1, (Object)this.getName(v));
                l.add((Number)-1, (Object)this.getName(u));
                this.problem.add(l, "<=", (Number)0);
            }
            if (v.getMin() > 0) {
                l = new Linear();
                l.add((Number)1, (Object)this.getName(u));
                l.add((Number)-1, (Object)this.getName(v));
                this.problem.add(l, "<=", (Number)0);
            }
        }
    }

    protected void addAllSameUnique(AssociationEnd u, AssociationEnd v) {
        Linear l = new Linear();
        l.add((Number)v.getMin(), (Object)this.getName(u));
        l.add((Number)-1, (Object)this.getName(v));
        this.problem.add(l, "<=", (Number)0);
        if (u.getMin() > 0) {
            l = new Linear();
            l.add((Number)1, (Object)this.getName(v));
            l.add((Number)v.getMax(), (Object)this.getName(u));
            this.problem.add(l, "<=", (Number)0);
        }
    }

    protected void addAllSameNonUnique(AssociationEnd u, AssociationEnd v) {
        Linear l;
        if (u.getMax() > 0) {
            l = new Linear();
            l.add((Number)((v.getMin() + u.getMax() - 1) / u.getMax()), (Object)this.getName(u));
            l.add((Number)-1, (Object)this.getName(v));
            this.problem.add(l, "<=", (Number)0);
        }
        if (u.getMin() > 0) {
            l = new Linear();
            l.add((Number)1, (Object)this.getName(v));
            l.add((Number)(-(v.getMax() / u.getMin())), (Object)this.getName(u));
            this.problem.add(l, "<=", (Number)0);
        }
    }

    protected void setVarTypes() {
        for (Object o : this.problem.getVariables()) {
            this.problem.setVarType(o, VarType.INT);
        }
    }

    public void setObjective(OptType type) {
        this.setVarTypes();
        Linear linear = new Linear();
        for (Class c : this.diagram.getClasses()) {
            Linear children = new Linear();
            Linear children2 = new Linear();
            for (AssociationEnd cae : c.getEnds()) {
                AssociationEnd ae = cae.getOther();
                if (ae.type != AssociationAttribute.UNIQUE || cae.type != AssociationAttribute.UNIQUE || ae.getMin() != ae.getMax() || cae.getMin() == cae.getMax()) continue;
                children.add((Number)ae.getMax(), (Object)SpecificationILPExport.makeVar(cae.assclass.getName()));
                children2.add((Number)ae.getMax(), (Object)SpecificationILPExport.makeVar(cae.assclass.getName()));
            }
            if (children.size() > 1) {
                if (c.getMinPartner() != 0) {
                    children.add((Number)(-c.getMinPartner()), (Object)SpecificationILPExport.makeVar(c.getName()));
                    this.problem.add(children, ">=", (Number)0);
                }
                if (c.getMaxParnter() != Environment.CARDINALITY_STAR) {
                    children2.add((Number)(-c.getMaxParnter()), (Object)SpecificationILPExport.makeVar(c.getName()));
                    this.problem.add(children2, "<=", (Number)0);
                }
            }
            linear.add((Number)c.getWeight(), (Object)SpecificationILPExport.makeVar(c.getName()));
        }
        this.problem.setObjective(linear, type);
    }
}

