/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.Domain;
import clews.data.Configuration;
import clews.data.DataObject;
import clews.data.Specification;
import clews.export.ConfigurationXMLImport;
import clews.export.SpecificationXMLImport;
import java.io.File;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class DomainXMLImport {
    protected ArrayList<Configuration> configurations;
    protected Specification specification;
    protected String dir;
    protected String active;
    protected Domain domain;

    public ArrayList<Configuration> getConfigurations() {
        return this.configurations;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public String getActive() {
        return this.active;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public boolean loadFromDisk(String path) {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.dir = new File(path).getParent();
            if (this.dir == null) {
                this.dir = "";
            }
            this.active = null;
            this.domain = new Domain();
            DiagramSaxParser sax = new DiagramSaxParser();
            sax.setParent(reader);
            sax.parse(path);
            this.setIds();
            this.domain.newDomain(false);
            this.domain.setPath(path);
            this.domain.setConfigurations(this.getConfigurations());
            this.domain.setSpecification(this.getSpecification());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected void setIds() {
        int max = Integer.MIN_VALUE;
        for (Configuration c : this.configurations) {
            max = Math.max(max, c.getId());
        }
        DataObject.setId(Configuration.class, max);
    }

    class DiagramSaxParser
    extends XMLFilterImpl {
        DiagramSaxParser() {
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
            ConfigurationXMLImport cxi;
            Configuration c;
            if (localName.equals("domain") && atts.getIndex("active") != -1) {
                DomainXMLImport.this.active = atts.getValue("active");
            }
            if (localName.equals("specification")) {
                SpecificationXMLImport sxi = new SpecificationXMLImport();
                DomainXMLImport.this.specification = sxi.loadFromDisk(String.valueOf(DomainXMLImport.this.dir) + File.separator + atts.getValue("path"));
            } else if (localName.equals("configurations")) {
                DomainXMLImport.this.configurations = new ArrayList();
            } else if (localName.equals("configuration") && (c = (cxi = new ConfigurationXMLImport(DomainXMLImport.this.specification)).loadFromDisk(String.valueOf(DomainXMLImport.this.dir) + File.separator + atts.getValue("path"))) != null) {
                c.setName(atts.getValue("name"));
                DomainXMLImport.this.configurations.add(c);
            }
            super.startElement(namespaceURI, localName.toLowerCase(), qualifiedName.toLowerCase(), atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            super.endElement(namespaceURI, localName.toLowerCase(), qualifiedName.toLowerCase());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
        }
    }
}

