/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.Domain;
import clews.MainFrame;
import clews.data.Configuration;
import clews.env.Environment;
import clews.export.ConfigurationXMLExport;
import clews.export.SpecificationXMLExport;
import clews.export.XMLExport;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class DomainXMLExport
extends XMLExport {
    protected Domain domain;
    protected static String ClewsSeperator = "\\";

    public DomainXMLExport(Domain d) {
        this.domain = d;
    }

    @Override
    public boolean saveToDisk(String path) {
        return this.saveToDisk(path, false);
    }

    public boolean saveToDisk(String path, boolean isTmp) {
        try {
            if (!isTmp) {
                this.domain.setPath(null);
                this.domain.getSpecification().setPath(null);
                for (Configuration c : this.domain.getConfigurations()) {
                    c.setPath(null);
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.doc.setXmlStandalone(true);
            SpecificationXMLExport sxe = new SpecificationXMLExport(this.domain.getSpecification());
            String spath = path.replace("." + Environment.DOMAIN_ENDING, "." + Environment.SPECIFICATION_ENDING);
            if (!sxe.save(spath, isTmp)) {
                throw new Exception("Error while saving specification");
            }
            Element main = this.doc.createElement("domain");
            if (MainFrame.getInstance().getDiagramPanel() != null) {
                this.addAttribute(main, "active", MainFrame.getInstance().getDiagramPanel().getDiagram().getName());
                if (isTmp) {
                    this.addAttribute(main, "tmppath", this.domain.getPath());
                }
            }
            Element cur = this.doc.createElement("specification");
            if (isTmp) {
                this.addAttribute(cur, "tmppath", this.domain.getSpecification().getPath());
            }
            this.addAttribute(cur, "path", "." + File.separator + new File(this.domain.getSpecification().getPath()).getName());
            main.appendChild(cur);
            Element configs = this.doc.createElement("configurations");
            for (Configuration c : this.domain.getConfigurations()) {
                cur = this.doc.createElement("configuration");
                this.addAttribute(cur, "name", c.getName());
                if (isTmp) {
                    this.addAttribute(cur, "tmppath", c.getPath());
                }
                ConfigurationXMLExport cxe = new ConfigurationXMLExport(c);
                cxe.save(path, isTmp);
                this.addAttribute(cur, "path", "." + File.separator + new File(c.getPath()).getName());
                configs.appendChild(cur);
            }
            main.appendChild(configs);
            this.doc.appendChild(main);
            this.toDisk(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.domain.setPath(path);
        return true;
    }
}

