/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.data.Class;
import clews.data.Configuration;
import clews.data.DataObject;
import clews.data.Instance;
import clews.data.Link;
import clews.data.Specification;
import clews.gui.view.ConfigurationView;
import java.awt.Point;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigurationXMLImport {
    protected Configuration configuration;
    protected ConfigurationView configurationView;
    protected Specification specification;
    protected ArrayList<Instance> ends;
    protected String description;

    public ConfigurationXMLImport(Specification s) {
        this.specification = s;
    }

    public Configuration loadFromDisk(String path) {
        this.configuration = null;
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            DiagramSaxParser sax = new DiagramSaxParser();
            sax.setParent(reader);
            sax.parse(path);
            this.setIds();
            this.configuration.applyChanges();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return this.configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void setIds() {
        int max = Integer.MIN_VALUE;
        for (Instance i : this.configuration.getInstances()) {
            max = Math.max(max, i.getId());
        }
        DataObject.setId(Instance.class, max);
        max = Integer.MIN_VALUE;
        for (Link l : this.configuration.getLinks()) {
            max = Math.max(max, l.getId());
        }
        DataObject.setId(Link.class, max);
    }

    class DiagramSaxParser
    extends XMLFilterImpl {
        DiagramSaxParser() {
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
            if (localName.equals("configuration")) {
                ConfigurationXMLImport.this.configuration = new Configuration(ConfigurationXMLImport.this.specification);
                ConfigurationXMLImport.this.configurationView = new ConfigurationView(ConfigurationXMLImport.this.configuration);
                ConfigurationXMLImport.this.configuration.setView(ConfigurationXMLImport.this.configurationView);
                if (atts.getIndex("scale") != -1) {
                    ConfigurationXMLImport.this.configurationView.getDiagram().setTransformParameter(Double.parseDouble(atts.getValue("scale")), Double.parseDouble(atts.getValue("transx")), Double.parseDouble(atts.getValue("transy")));
                }
            } else if (localName.equals("instance")) {
                Class c = ConfigurationXMLImport.this.specification.getClassForName(atts.getValue("instanceOf"));
                if (c == null) throw new SAXException("invalid configuration for specification");
                Point p = new Point();
                if (atts.getIndex("x") != -1) {
                    p = new Point(Integer.parseInt(atts.getValue("x")), Integer.parseInt(atts.getValue("y")));
                }
                Instance i = ConfigurationXMLImport.this.configurationView.addDropInstance(c, p);
                i.setName(atts.getValue("name"));
                i.setId(Integer.parseInt(atts.getValue("id")));
            } else if (localName.equals("link")) {
                ConfigurationXMLImport.this.description = null;
                if (atts.getIndex("description") != -1) {
                    ConfigurationXMLImport.this.description = atts.getValue("description");
                }
                ConfigurationXMLImport.this.ends = new ArrayList();
            } else if (localName.equals("linkend")) {
                ConfigurationXMLImport.this.ends.add(ConfigurationXMLImport.this.configuration.getInstanceById(Integer.parseInt(atts.getValue("instance"))));
            }
            super.startElement(namespaceURI, localName.toLowerCase(), qualifiedName.toLowerCase(), atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
            if (localName.equals("link")) {
                Link l = ConfigurationXMLImport.this.configuration.link(ConfigurationXMLImport.this.ends);
                if (ConfigurationXMLImport.this.description != null) {
                    l.setDescription(ConfigurationXMLImport.this.description);
                }
                ConfigurationXMLImport.this.configurationView.addNewLinkView(l);
            }
            super.endElement(namespaceURI, localName.toLowerCase(), qualifiedName.toLowerCase());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
        }
    }
}

