/*
 * Decompiled with CFR 0.152.
 */
package clews.export;

import clews.data.Configuration;
import clews.data.Instance;
import clews.data.Link;
import clews.env.Environment;
import clews.export.XMLExport;
import clews.gui.view.ConfigurationView;
import clews.gui.view.InstanceView;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class ConfigurationXMLExport
extends XMLExport {
    protected Configuration configuration;

    public ConfigurationXMLExport(Configuration c) {
        this.configuration = c;
    }

    @Override
    public boolean saveToDisk(String path) {
        return this.save(path, false);
    }

    public boolean save(String path, boolean isTmp) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.doc.setXmlStandalone(true);
            Element main = this.doc.createElement("configuration");
            if (!isTmp && this.configuration.getPath() != null) {
                path = this.configuration.getPath();
            } else {
                path = path.replace("." + Environment.DOMAIN_ENDING, "." + this.configuration.getName() + "." + Environment.CONFIGURATION_ENDING);
                this.configuration.setPath(path);
            }
            if (this.configuration.getView() != null) {
                AffineTransform trafo = ((ConfigurationView)this.configuration.getView()).getDiagram().getTransform();
                this.addAttribute(main, "scale", "" + trafo.getScaleX());
                this.addAttribute(main, "transx", "" + trafo.getTranslateX());
                this.addAttribute(main, "transy", "" + trafo.getTranslateY());
            }
            this.doc.appendChild(main);
            ArrayList<Instance> instances = this.configuration.getInstances();
            for (Instance i : instances) {
                Element cur = this.doc.createElement("instance");
                main.appendChild(cur);
                this.addAttribute(cur, "id", "" + i.getId());
                this.addAttribute(cur, "name", i.getName());
                this.addAttribute(cur, "instanceOf", i.getType().getName());
                InstanceView view = (InstanceView)i.getView();
                if (view == null) continue;
                this.addAttribute(cur, "x", "" + (int)view.getCenter().getX());
                this.addAttribute(cur, "y", "" + (int)view.getCenter().getY());
                this.addAttribute(cur, "radius", "" + view.getRadius());
            }
            ArrayList<Link> links = this.configuration.getLinks();
            for (Link l : links) {
                Element cur = this.doc.createElement("link");
                if (l.getDescription() != null) {
                    this.addAttribute(cur, "description", l.getDescription());
                }
                main.appendChild(cur);
                for (Instance i : l.getInstances()) {
                    Element end = this.doc.createElement("linkend");
                    this.addAttribute(end, "instance", "" + i.getId());
                    cur.appendChild(end);
                }
            }
            this.toDisk(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

