/*
 * Decompiled with CFR 0.152.
 */
package clews.env;

import clews.env.Environment;
import java.io.File;

public class Utils {
    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String toStarNum(int num) {
        if (num == Environment.CARDINALITY_STAR) {
            return "*";
        }
        return "" + num;
    }

    public static int fromStarNum(String num, int def) {
        if (num.equals("*")) {
            return Environment.CARDINALITY_STAR;
        }
        if (Utils.isInteger(num)) {
            return Integer.parseInt(num);
        }
        return def;
    }

    public static int sign(int val) {
        if (val > 0) {
            return 1;
        }
        if (val < 0) {
            return -1;
        }
        return 0;
    }

    public static String relative(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        String relFileName = absFileName.substring(rootLength + 1);
        return relFileName;
    }

    public static String getExtension(String file) {
        return file.substring(file.lastIndexOf(".") + 1);
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return Utils.gcd(b, a % b);
    }

    public static int lcm(int a, int b) {
        return a * b / Utils.gcd(a, b);
    }
}

