/*
 * Decompiled with CFR 0.152.
 */
package clews.env;

import clews.data.Instance;
import clews.data.Link;
import java.util.ArrayList;

public class Graph {
    protected ArrayList<Node> nodes;
    protected ArrayList<Edge> edges;
    protected Node source;
    protected Node sink;

    public void init(int l, ArrayList<Instance> left, ArrayList<Instance> right, ArrayList<Link> links) {
        Edge e;
        Node n;
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.source = new Node(null, l -= links.size());
        this.sink = new Node(null, l);
        this.nodes.add(this.source);
        this.nodes.add(this.sink);
        for (Instance i : left) {
            n = new Node(i, 0);
            this.nodes.add(n);
            e = new Edge(this.source, n, 1, l / left.size(), (l + left.size() - 1) / left.size());
            this.edges.add(e);
            this.source.out.add(e);
            e.back = new Edge(n, this.source, 0, 0, 0);
            e.back.back = e;
            n.out.add(e.back);
        }
        for (Instance i : right) {
            n = new Node(i, 0);
            this.nodes.add(n);
            e = new Edge(n, this.sink, 1, l / right.size(), (l + right.size() - 1) / right.size());
            this.edges.add(e);
            n.out.add(e);
            e.back = new Edge(this.sink, n, 0, 0, 0);
            e.back.back = e;
            this.sink.out.add(e.back);
        }
        for (Instance i : left) {
            for (Instance i2 : right) {
                if (this.exisiting(links, i, i2)) continue;
                e = new Edge(this.getNode(i), this.getNode(i2), 1, 0, 1);
                this.edges.add(e);
                this.getNode((Instance)i).out.add(e);
                e.back = new Edge(this.getNode(i2), this.getNode(i), 0, 0, 0);
                e.back.back = e;
                this.getNode((Instance)i2).out.add(e.back);
            }
        }
        for (Edge ee : this.edges) {
            System.out.println(String.valueOf(ee.mincap) + " " + ee.maxcap);
        }
    }

    boolean exisiting(ArrayList<Link> ls, Instance i1, Instance i2) {
        for (Link l : ls) {
            if ((l.getLeft() != i1 || l.getRight() != i2) && (l.getLeft() != i2 || l.getRight() != i1)) continue;
            return true;
        }
        return false;
    }

    Node getNode(Instance i) {
        for (Node n : this.nodes) {
            if (n.rep != i) continue;
            return n;
        }
        return null;
    }

    Edge getEdgeForInstances(Instance from, Instance to) {
        for (Edge e : this.edges) {
            if (e.from.rep != from || e.to.rep != to) continue;
            return e;
        }
        return null;
    }

    public boolean isFlow(Instance from, Instance to) {
        Edge e = this.getEdgeForInstances(from, to);
        if (e != null) {
            return e.flow != 0;
        }
        return false;
    }

    public boolean findFeasible() {
        while (this.source.req > 0) {
            ArrayList<Edge> p = this.findPath(this.source, this.sink);
            if (p == null) {
                return false;
            }
            for (Edge e : p) {
                ++e.flow;
                --e.from.req;
                ++e.to.req;
                --e.back.flow;
            }
        }
        return true;
    }

    ArrayList<Edge> findPath(Node from, Node to) {
        return this.findPathRecursive(from, to, new ArrayList<Node>(), new ArrayList<Edge>());
    }

    ArrayList<Edge> findPathRecursive(Node cur, Node dest, ArrayList<Node> visited, ArrayList<Edge> path) {
        visited.add(cur);
        if (cur == dest) {
            return path;
        }
        for (Edge e : cur.out) {
            if (visited.contains(e.to) || e.flow + 1 > e.maxcap) continue;
            path.add(e);
            ArrayList<Edge> ret = this.findPathRecursive(e.to, dest, visited, path);
            if (ret != null) {
                return ret;
            }
            path.remove(e);
        }
        return null;
    }

    class Edge {
        int weight;
        int flow;
        int mincap;
        int maxcap;
        Node from;
        Node to;
        Edge back;

        public Edge(Node f, Node t, int w, int min, int max) {
            this.from = f;
            this.to = t;
            this.weight = w;
            this.flow = 0;
            this.mincap = min;
            this.maxcap = max;
        }
    }

    class Node {
        int req;
        Instance rep;
        ArrayList<Edge> out;

        public Node(Instance i, int r) {
            this.rep = i;
            this.req = r;
            this.out = new ArrayList();
        }
    }
}

