/*
 * Decompiled with CFR 0.152.
 */
package clews.data;

import clews.MainFrame;
import clews.data.Association;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.Configuration;
import clews.data.Constraint;
import clews.data.DataObject;
import clews.data.Instance;
import clews.env.Environment;
import clews.export.SpecificationILPExport;
import clews.gui.view.ConfigurationView;
import clews.gui.view.SpecificationView;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.javailp.OptType;
import net.sf.javailp.Problem;
import net.sf.javailp.Result;

public class Specification
extends DataObject<SpecificationView> {
    protected ArrayList<Class> classes;
    protected ArrayList<Association> associations;
    protected ArrayList<Constraint> constraints;
    protected boolean isConsistent = true;
    protected Result minimalModel;
    protected String path;
    protected HashMap<Class, Number> cmap = new HashMap();
    protected HashMap<Number, Class> nmap = new HashMap();
    protected HashMap<String, Class> smap = new HashMap();

    public Specification() {
        this.classes = new ArrayList();
        this.associations = new ArrayList();
        this.constraints = new ArrayList();
    }

    public Result getMinimalModel() {
        return this.minimalModel;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public Class addNewClass() {
        return this.addNewClass(Environment.NO_CLASS_ID);
    }

    public boolean isConsistent() {
        return this.isConsistent;
    }

    public Class addNewClass(int id) {
        System.out.println("KlassenID=" + id);
        Class c = new Class(this, id);
        this.classes.add(c);
        return c;
    }

    public Constraint addNewConstraint() {
        Constraint c = new Constraint(this);
        this.constraints.add(c);
        return c;
    }

    public void delete(Constraint c) {
        c.removeFromAssociations();
        this.constraints.remove(c);
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public ArrayList<Association> delete(Class c) {
        ArrayList<Association> todel = new ArrayList<Association>();
        for (Association a : this.associations) {
            if (a.getLeftClass() != c && a.getRightClass() != c) continue;
            todel.add(a);
        }
        for (Association a : todel) {
            this.delete(a);
        }
        this.classes.remove(c);
        return todel;
    }

    public void delete(Association a) {
        this.associations.remove(a);
    }

    public Class getClassById(int id) {
        for (Class c : this.classes) {
            if (c.id != id) continue;
            return c;
        }
        return null;
    }

    public Association getAssociationById(int id) {
        for (Association a : this.associations) {
            if (a.id != id) continue;
            return a;
        }
        return null;
    }

    public Association getAssociationForName(String name) {
        for (Association a : this.associations) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public Association associate(Class c1, Class c2) {
        return this.associate(c1, c2, true);
    }

    public Association associate(Class c1, Class c2, boolean applyChanges) {
        Association a2;
        for (Association a2 : this.associations) {
            if ((a2.getLeft().assclass != c1 || a2.getRight().assclass != c2) && (a2.getLeft().assclass != c2 || a2.getRight().assclass != c1)) continue;
            return null;
        }
        a2 = new Association(c1, c2);
        this.associations.add(a2);
        c1.addAssociationEnd(a2.getRight());
        c2.addAssociationEnd(a2.getLeft());
        if (applyChanges) {
            this.applyChanges();
        }
        return a2;
    }

    public Association associate(ArrayList<AssociationEnd> ends) {
        return this.associate(ends, true);
    }

    public Association associate(ArrayList<AssociationEnd> ends, boolean applyChanges) {
        Association a = new Association(ends);
        if (a.isBinary()) {
            this.associations.add(a);
            a.getLeft().assclass.addAssociationEnd(a.getRight());
            a.getRight().assclass.addAssociationEnd(a.getLeft());
            if (applyChanges) {
                this.applyChanges();
            }
        }
        return a;
    }

    public void applyChanges() {
        for (Class clazz : this.classes) {
            clazz.setIsConsistent(true);
        }
        for (Association association : this.associations) {
            association.setIsConsistent(true);
        }
        this.isConsistent = this.check();
        if (!this.isConsistent) {
            for (Association association : this.associations) {
                if (association.getLeft().assclass.isConsistent() || association.getRight().assclass.isConsistent()) continue;
                association.setIsConsistent(false);
            }
        } else {
            SpecificationILPExport specificationILPExport = new SpecificationILPExport(this);
            specificationILPExport.export();
            specificationILPExport.setObjective(OptType.MIN);
            this.minimalModel = specificationILPExport.solve();
            if (this.minimalModel != null) {
                for (String var : this.smap.keySet()) {
                    if (!this.minimalModel.containsVar((Object)var).booleanValue()) continue;
                    this.smap.get(var).setMinModelObj(this.minimalModel.get((Object)var).intValue());
                }
            }
        }
        if (MainFrame.getInstance() != null && MainFrame.getInstance().getDomain() != null) {
            for (Configuration configuration : MainFrame.getInstance().getDomain().getConfigurations()) {
                for (Instance i : configuration.getInstances()) {
                    i.applyChanges();
                }
            }
        }
    }

    public Configuration createMinimalConfiguration() {
        Configuration config = null;
        this.applyChanges();
        if (this.isConsistent) {
            config = MainFrame.getInstance().getDomain().addNewConfiguration();
            if (this.minimalModel != null) {
                int y = 100;
                for (String var : this.smap.keySet()) {
                    if (this.minimalModel.containsVar((Object)var).booleanValue()) {
                        Class c = this.getClassForName(var.replace("|", ""));
                        int cnt = this.minimalModel.get((Object)var).intValue();
                        int i = 0;
                        while (i < cnt) {
                            ((ConfigurationView)config.getView()).addDropInstance(c, new Point(500 - 200 * cnt / 2 + i * 200, y));
                            ++i;
                        }
                    }
                    y += 150;
                }
                for (Association a : this.associations) {
                    config.addMinLinks(a.left, a.right);
                }
            }
        }
        return config;
    }

    public Class getClassForName(String name) {
        for (Class c : this.classes) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    protected void markPath(int i, int[][] pred) {
        int b;
        int a = b = i;
        int cur = b;
        do {
            this.nmap.get(cur).setIsConsistent(false);
            System.out.println("-> " + cur);
            if (pred[a][b] == cur) break;
            b = cur = pred[a][b];
        } while (cur != i && cur != -1);
        a = b = i;
        cur = b;
        do {
            this.nmap.get(cur).setIsConsistent(false);
            System.out.println("-> " + cur);
            if (pred[a][b] == cur) break;
            a = cur = pred[a][b];
        } while (cur != i && cur != -1);
    }

    protected boolean check() {
        int jj;
        int ii;
        int j;
        int nodes = this.classes.size();
        double[][] adjm = new double[nodes][nodes];
        int[][] pred = new int[nodes][nodes];
        boolean[][] orig = new boolean[nodes][nodes];
        this.cmap = new HashMap();
        this.nmap = new HashMap();
        this.smap = new HashMap();
        int i = 0;
        while (i < nodes) {
            this.smap.put(SpecificationILPExport.makeVar(this.classes.get(i).getName()), this.classes.get(i));
            this.cmap.put(this.classes.get(i), i);
            this.nmap.put(i, this.classes.get(i));
            int j2 = 0;
            while (j2 < nodes) {
                adjm[i][j2] = 2.147483647E9;
                pred[i][j2] = -1;
                orig[i][j2] = false;
                ++j2;
            }
            ++i;
        }
        SpecificationILPExport ilp = new SpecificationILPExport(this);
        Problem p = ilp.export();
        for (net.sf.javailp.Constraint c : p.getConstraints()) {
            if (c.getRhs().intValue() != 0 || c.getLhs().size() != 2) continue;
            int a = 0;
            int b = 1;
            if (c.getLhs().get(0).getCoefficient().intValue() < 0) {
                a = 1;
                b = 0;
            }
            int x = this.cmap.get(this.smap.get(c.getLhs().get(a).getVariable())).intValue();
            int y = this.cmap.get(this.smap.get(c.getLhs().get(b).getVariable())).intValue();
            orig[x][y] = true;
            adjm[x][y] = c.getLhs().get(a).getCoefficient().doubleValue() == 0.0 ? 2.147483647E9 : -c.getLhs().get(b).getCoefficient().doubleValue() / c.getLhs().get(a).getCoefficient().doubleValue();
        }
        int k = 0;
        while (k < nodes) {
            int i2 = 0;
            while (i2 < nodes) {
                j = 0;
                while (j < nodes) {
                    if (adjm[i2][k] != 2.147483647E9 && adjm[k][j] != 2.147483647E9 && !orig[i2][j] && adjm[i2][k] * adjm[k][j] < adjm[i2][j]) {
                        adjm[i2][j] = adjm[i2][k] * adjm[k][j];
                        pred[i2][j] = k;
                        if (i2 == j && adjm[i2][j] < 1.0) {
                            System.out.println();
                            ii = 0;
                            while (ii < nodes) {
                                jj = 0;
                                while (jj < nodes) {
                                    System.out.print(String.valueOf(adjm[ii][jj]) + "\t");
                                    ++jj;
                                }
                                System.out.println();
                                ++ii;
                            }
                            this.markPath(i2, pred);
                            return false;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        k = 0;
        while (k < nodes) {
            int i3 = 0;
            while (i3 < nodes) {
                j = 0;
                while (j < nodes) {
                    if (adjm[i3][k] != 2.147483647E9 && adjm[k][j] != 2.147483647E9 && adjm[i3][k] * adjm[k][j] < adjm[i3][j]) {
                        adjm[i3][j] = adjm[i3][k] * adjm[k][j];
                        pred[i3][j] = k;
                        if (i3 == j && adjm[i3][j] < 1.0) {
                            System.out.println();
                            ii = 0;
                            while (ii < nodes) {
                                jj = 0;
                                while (jj < nodes) {
                                    System.out.print(String.valueOf(adjm[ii][jj]) + "\t");
                                    ++jj;
                                }
                                System.out.println();
                                ++ii;
                            }
                            this.markPath(i3, pred);
                            return false;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            ++k;
        }
        int i4 = 0;
        while (i4 < nodes) {
            if (adjm[i4][i4] > 0.0 && adjm[i4][i4] < 1.0) {
                this.markPath(i4, pred);
                return false;
            }
            ++i4;
        }
        return true;
    }

    public ArrayList<Class> getClasses() {
        return this.classes;
    }

    public ArrayList<Association> getAssociations() {
        return this.associations;
    }
}

