/*
 * Decompiled with CFR 0.152.
 */
package clews.data;

import clews.data.AssociationAttribute;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.Configuration;
import clews.data.DataObject;
import clews.data.Link;
import clews.env.Environment;
import clews.env.Utils;
import clews.gui.view.InstanceView;
import clews.gui.view.LinkView;
import java.util.ArrayList;
import java.util.HashMap;

public class Instance
extends DataObject<InstanceView> {
    protected Class type;
    protected String name;
    protected Configuration config;
    protected HashMap<Number, ArrayList<Link>> links;
    protected HashMap<Number, Number> linkcnts;
    protected HashMap<Number, ArrayList<Instance>> linkedinstances;
    protected ArrayList<String> conflicts;
    protected boolean isConsistent;

    public Instance(Configuration co, Class c) {
        this.config = co;
        this.name = c.getName();
        this.type = c;
        this.links = new HashMap();
        this.linkcnts = new HashMap();
        this.linkedinstances = new HashMap();
        this.isConsistent = false;
        this.conflicts = new ArrayList();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void applyChanges() {
        String message;
        boolean isOr;
        boolean conflict = false;
        this.conflicts = new ArrayList();
        int orCnt = 0;
        boolean bl = isOr = this.getType().getMinPartner() > 0 || this.getType().getMaxParnter() != Environment.CARDINALITY_STAR;
        if (isOr) {
            isOr = true;
        }
        for (AssociationEnd ae : this.type.getEnds()) {
            block17: {
                block18: {
                    block15: {
                        block16: {
                            message = "";
                            conflict = false;
                            if (ae.type != AssociationAttribute.UNIQUE) break block15;
                            if (!isOr || !this.type.orPartner.contains(ae.assclass.getId())) break block16;
                            if (!this.linkedinstances.containsKey(ae.assclass.getId())) break block17;
                            ++orCnt;
                            break block17;
                        }
                        ArrayList<Instance> tmp = new ArrayList<Instance>();
                        ArrayList<Instance> insts = null;
                        int lc = 0;
                        if (this.linkedinstances.containsKey(ae.assclass.getId())) {
                            insts = this.linkedinstances.get(ae.assclass.getId());
                            lc = insts.size();
                        }
                        if (lc < ae.getMin()) {
                            conflict = true;
                            message = lc + this.getCardString(lc, " link");
                        }
                        if (lc <= 0) break block17;
                        for (Instance i : insts) {
                            if (tmp.contains(i)) continue;
                            tmp.add(i);
                        }
                        lc = tmp.size();
                        if (lc < ae.getMin() || ae.getMax() != Environment.CARDINALITY_STAR && lc > ae.getMax()) {
                            conflict = true;
                            message = lc + this.getCardString(lc, " unique object");
                        }
                        break block17;
                    }
                    if (ae.type != AssociationAttribute.NON_UNIQUE) break block18;
                    int lc = 0;
                    if (this.linkedinstances.containsKey(ae.assclass.getId())) {
                        ArrayList<Instance> insts = this.linkedinstances.get(ae.assclass.getId());
                        lc = insts.size();
                    }
                    boolean bl2 = conflict = lc < ae.getMin() || ae.getMax() != Environment.CARDINALITY_STAR && lc > ae.getMax();
                    if (!conflict) break block17;
                    message = lc + this.getCardString(lc, " link");
                    break block17;
                }
                if (ae.type == AssociationAttribute.ALL_SAME) {
                    ArrayList<Instance> insts = null;
                    int lc = 0;
                    if (this.linkedinstances.containsKey(ae.assclass.getId())) {
                        insts = this.linkedinstances.get(ae.assclass.getId());
                        lc = insts.size();
                    }
                    if (lc < ae.getMin() || ae.getMax() != Environment.CARDINALITY_STAR && lc > ae.getMax()) {
                        conflict = true;
                        message = lc + this.getCardString(lc, " link");
                    }
                    if (lc > 0) {
                        Instance master = insts.get(0);
                        for (Instance i : insts) {
                            if (i == master) continue;
                            conflict = true;
                            message = "Not all the same";
                            break;
                        }
                    }
                }
            }
            if (!conflict) continue;
            this.conflicts.add(this.getConflicString(ae, message));
        }
        if (isOr) {
            System.out.println(String.valueOf(this.getName()) + "  " + orCnt);
        }
        if (isOr && (orCnt < this.getType().getMinPartner() || this.getType().getMaxParnter() != Environment.CARDINALITY_STAR && orCnt > this.getType().getMaxParnter())) {
            conflict = true;
            message = String.valueOf(this.getType().getName()) + " defines or[" + this.getType().getMinPartner() + ".." + Utils.toStarNum(this.getType().getMaxParnter()) + "]";
            this.conflicts.add(String.valueOf(message) + "; Current: " + orCnt);
        }
        if (this.view != null) {
            ((InstanceView)this.view).setPositionChanged();
        }
        this.isConsistent = this.conflicts.size() == 0;
    }

    protected String getCardString(int cnt, String str) {
        return String.valueOf(str) + (cnt > 1 ? "s" : "");
    }

    public String getConflicString(AssociationEnd ae, String message) {
        String ret = String.valueOf(ae.assoc.getName()) + ": [" + ae.getMin() + ".." + ae.getMax() + "] " + ae.type.name() + " to " + ae.assclass.getName();
        if (message != null && message.length() > 0) {
            ret = String.valueOf(ret) + "; Current: " + message;
        }
        return ret;
    }

    public String getConflictString(String message) {
        return message;
    }

    public String reportConflicts() {
        String ret = "";
        if (!this.isConsistent()) {
            ret = "<html>";
            for (String c : this.conflicts) {
                ret = String.valueOf(ret) + c + "<br>";
            }
        }
        return ret.replace("-1", "*");
    }

    public boolean isConsistent() {
        return this.isConsistent;
    }

    public void addLink(Link l, Instance i2) {
        if (!this.links.containsKey(i2.getId())) {
            this.links.put(i2.getId(), new ArrayList());
        }
        if (!this.linkcnts.containsKey(i2.getId())) {
            this.linkcnts.put(i2.getId(), 0);
        }
        if (!this.linkedinstances.containsKey(i2.getType().getId())) {
            this.linkedinstances.put(i2.getType().getId(), new ArrayList());
        }
        this.links.get(i2.getId()).add(l);
        this.linkcnts.put(i2.getId(), this.linkcnts.get(i2.getId()).intValue() + 1);
        this.linkedinstances.get(i2.getType().getId()).add(i2);
    }

    public void removeLink(Link li, Instance i2, int cnt) {
        if (this.links.containsKey(i2.getId())) {
            for (Link l : this.links.get(i2.getId())) {
                if (l.getView() == null) continue;
                if (l.left == i2 && ((LinkView)l.getView()).getLeftCnt() > cnt) {
                    ((LinkView)l.getView()).decreaseLeft();
                }
                if (l.right != i2 || ((LinkView)l.getView()).getRightCnt() <= cnt) continue;
                ((LinkView)l.getView()).decreaseRight();
            }
            this.links.get(i2.getId()).remove(li);
        }
        int ncnt = 0;
        if (this.linkcnts.containsKey(i2.getId())) {
            ncnt = this.linkcnts.get(i2.getId()).intValue() - 1;
            this.linkcnts.put(i2.getId(), ncnt);
        }
        if (this.linkedinstances.containsKey(i2.getType().getId())) {
            this.linkedinstances.get(i2.getType().getId()).remove(i2);
        }
    }

    public int getNumberOfLinks(Instance i2) {
        if (!this.linkcnts.containsKey(i2.getId())) {
            return 0;
        }
        return this.linkcnts.get(i2.getId()).intValue();
    }

    public HashMap<Number, ArrayList<Link>> getLinks() {
        return this.links;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Class getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        if (this.view != null) {
            ((InstanceView)this.view).setSizeFromName();
        }
    }
}

