/*
 * Decompiled with CFR 0.152.
 */
package clews.data;

import clews.data.Association;
import clews.data.AssociationAttribute;
import clews.data.DataObject;
import clews.data.Specification;
import clews.env.Environment;
import clews.env.Utils;
import clews.gui.view.ConstraintView;
import java.util.ArrayList;

public class Constraint
extends DataObject<ConstraintView> {
    protected Specification specification;
    protected String name;
    protected String errorMessage;
    protected boolean active;
    protected ArrayList<ConstraintPart> lhs;
    protected ArrayList<ConstraintPart> rhs;
    protected Association reduced;
    protected int upperBound;
    protected int upperBoundBack;
    protected int lowerBound;
    protected int lowerBoundBack;
    protected int plhs;
    protected int prhs;
    protected int prod;
    protected int[] strongestBounds = new int[4];
    protected boolean reduceUpperLhs;
    protected boolean reduceUpperRhs;
    protected boolean reduceUpperLhsBack;
    protected boolean reduceUpperRhsBack;
    protected boolean increaseLowerLhs;
    protected boolean increaseLowerRhs;
    protected boolean increaseLowerLhsBack;
    protected boolean increaseLowerRhsBack;

    public Constraint(Specification s) {
        this.specification = s;
        this.name = "Constraint" + this.getId();
        this.active = true;
        this.lhs = new ArrayList();
        this.rhs = new ArrayList();
    }

    public String toString() {
        if (this.isActive()) {
            return this.getName();
        }
        return "[" + this.getName() + "]";
    }

    public boolean computeResultingInterval() {
        int[] b2;
        if (this.lhs.size() == 0 || this.rhs.size() == 0 || this.lhs.get((int)0).association.getTypeLeft() != this.rhs.get((int)0).association.getTypeLeft()) {
            this.errorMessage = "Left hand side and right hand side do not match";
            return false;
        }
        int[] b1 = b2 = (int[])null;
        if (this.lhs.get((int)0).association.getTypeLeft() == AssociationAttribute.NON_UNIQUE) {
            b1 = this.computeBoundsNonUnique(this.lhs);
            this.plhs = b1[2];
            b2 = this.computeBoundsNonUnique(this.rhs);
            this.prhs = b2[2];
        }
        if (this.lhs.get((int)0).association.getTypeLeft() == AssociationAttribute.UNIQUE) {
            b1 = this.computeBoundsUnique(this.lhs);
            this.plhs = b1[2];
            b2 = this.computeBoundsUnique(this.rhs);
            this.prhs = b2[2];
        }
        this.strongestBounds[0] = Math.max(b1[0], b2[0]);
        this.strongestBounds[1] = Math.min(b1[1], b2[1]);
        this.strongestBounds[2] = Math.max(b1[2], b2[2]);
        this.strongestBounds[3] = Math.min(b1[3], b2[3]);
        this.reduceUpperLhs = false;
        this.reduceUpperRhs = false;
        this.reduceUpperLhsBack = false;
        this.reduceUpperRhsBack = false;
        if (b1[3] > b2[3]) {
            this.reduceUpperLhs = true;
        } else if (b1[3] != b2[3]) {
            this.reduceUpperRhs = true;
        }
        if (b1[1] > b2[1]) {
            this.reduceUpperLhsBack = true;
        } else if (b1[1] != b2[1]) {
            this.reduceUpperRhsBack = true;
        }
        this.increaseLowerLhs = false;
        this.increaseLowerRhs = false;
        this.increaseLowerLhsBack = false;
        this.increaseLowerRhsBack = false;
        if (b1[2] < b2[2]) {
            this.increaseLowerLhs = true;
        } else if (b1[2] != b2[2]) {
            this.increaseLowerRhs = true;
        }
        if (b1[0] < b2[0]) {
            this.increaseLowerLhsBack = true;
        } else if (b1[0] != b2[0]) {
            this.increaseLowerRhsBack = true;
        }
        if (this.strongestBounds[0] > this.strongestBounds[1] || this.strongestBounds[2] > this.strongestBounds[3]) {
            this.errorMessage = "The left hand side is of type [" + b1[0] + ".." + b1[1] + "] --- [" + b1[2] + ".." + b1[3] + "]" + " and\n" + "the right hand side is of type " + "[" + b2[0] + ".." + b2[1] + "] --- [" + b2[2] + ".." + b2[3] + "].\n" + "Therefore the intersection is not satisfiable";
            return false;
        }
        System.out.println("Strongest bounds: " + this.strongestBounds[0] + " " + this.strongestBounds[1] + " " + this.strongestBounds[2] + " " + this.strongestBounds[3]);
        this.assignConstraint(this.lhs);
        this.assignConstraint(this.rhs);
        this.upperBound = this.strongestBounds[3];
        return true;
    }

    public boolean computeResultingIntervalOld() {
        int[] inter;
        int[] b2;
        if (this.lhs.size() == 0 || this.rhs.size() == 0 || this.lhs.get((int)0).association.getTypeLeft() != this.rhs.get((int)0).association.getTypeLeft()) {
            this.errorMessage = "Left hand side and right hand side do not match";
            return false;
        }
        int[] b1 = b2 = (int[])null;
        if (this.lhs.get((int)0).association.getTypeLeft() == AssociationAttribute.NON_UNIQUE) {
            b1 = this.computeBoundsNonUnique(this.lhs);
            this.plhs = this.prod;
            b2 = this.computeBoundsNonUnique(this.rhs);
            this.prhs = this.prod;
        }
        if (this.lhs.get((int)0).association.getTypeLeft() == AssociationAttribute.UNIQUE) {
            b1 = this.computeBoundsUnique(this.lhs);
            this.plhs = this.prod;
            b2 = this.computeBoundsUnique(this.rhs);
            this.prhs = this.prod;
        }
        if ((inter = new int[]{Math.max(b1[0], b2[0]), Math.min(b1[1], b2[1]), Math.max(b1[2], b2[2]), Math.min(b1[3], b2[3])})[0] > inter[1] || inter[2] > inter[3]) {
            this.errorMessage = "The left hand side is of type [" + b1[0] + ".." + b1[1] + "] --- [" + b1[2] + ".." + b1[3] + "]" + " and\n" + "the right hand side is of type " + "[" + b2[0] + ".." + b2[1] + "] --- [" + b2[2] + ".." + b2[3] + "].\n" + "Therefore the intersection is not satisfiable";
            return false;
        }
        System.out.println(String.valueOf(inter[0]) + " " + inter[1] + " " + inter[2] + " " + inter[3]);
        this.assignConstraint(this.lhs);
        this.assignConstraint(this.rhs);
        this.upperBound = inter[3];
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getLowerProduct(ConstraintPart cp) {
        if (this.lhs.contains(cp)) {
            return this.plhs;
        }
        if (this.rhs.contains(cp)) {
            return this.prhs;
        }
        return -1;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int[] getStrongestBounds() {
        return this.strongestBounds;
    }

    public boolean getIncreaseLowerLhs() {
        return this.increaseLowerLhs;
    }

    public boolean getIncreaseLowerRhs() {
        return this.increaseLowerRhs;
    }

    public boolean getIncreaseLowerLhsBack() {
        return this.increaseLowerLhsBack;
    }

    public boolean getIncreaseLowerRhsBack() {
        return this.increaseLowerRhsBack;
    }

    public boolean getReduceUpperLhs() {
        return this.reduceUpperLhs;
    }

    public boolean getReduceUpperRhs() {
        return this.reduceUpperRhs;
    }

    public boolean getReduceUpperLhsBack() {
        return this.reduceUpperLhsBack;
    }

    public boolean getReduceUpperRhsBack() {
        return this.reduceUpperRhsBack;
    }

    public void removeFromAssociations() {
        for (ConstraintPart cp : this.lhs) {
            cp.association.deleteConstraint(cp);
        }
        for (ConstraintPart cp : this.rhs) {
            cp.association.deleteConstraint(cp);
        }
    }

    protected void assignConstraint(ArrayList<ConstraintPart> parts) {
        for (ConstraintPart cp : parts) {
            cp.association.addConstraint(cp);
        }
    }

    protected int maxMul(int a, int b) {
        if (a == Integer.MAX_VALUE) {
            return a;
        }
        if (b == Environment.CARDINALITY_STAR) {
            return Integer.MAX_VALUE;
        }
        return a * b;
    }

    public int[] computeBoundsNonUnique(ArrayList<ConstraintPart> parts) {
        int[] bounds = new int[4];
        int i = 0;
        while (i < 4) {
            bounds[i] = 1;
            ++i;
        }
        this.prod = 1;
        for (ConstraintPart cp : parts) {
            if (!cp.inv) {
                bounds[0] = bounds[0] == 1 ? cp.association.getLeft().getMin() : bounds[0] * cp.association.getLeft().getMin();
                bounds[1] = this.maxMul(bounds[1], cp.association.getLeft().getMax());
                bounds[2] = bounds[2] == 1 ? cp.association.getRight().getMin() : bounds[2] * cp.association.getRight().getMin();
                bounds[3] = this.maxMul(bounds[3], cp.association.getRight().getMax());
                this.prod *= cp.association.getRight().getMin();
                continue;
            }
            bounds[2] = bounds[2] == 1 ? cp.association.getLeft().getMin() : bounds[2] * cp.association.getLeft().getMin();
            bounds[3] = this.maxMul(bounds[3], cp.association.getLeft().getMax());
            bounds[0] = bounds[0] == 1 ? cp.association.getRight().getMin() : bounds[0] * cp.association.getRight().getMin();
            bounds[1] = this.maxMul(bounds[3], cp.association.getRight().getMax());
            this.prod *= cp.association.getLeft().getMin();
        }
        return bounds;
    }

    public int[] computeBoundsUniqueOld(ArrayList<ConstraintPart> parts) {
        int[] bounds = new int[4];
        int i = 0;
        while (i < 4) {
            bounds[i] = 1;
            ++i;
        }
        this.prod = 1;
        int i2 = 0;
        while (i2 < parts.size()) {
            ConstraintPart cp = parts.get(i2);
            if (!cp.inv) {
                if (i2 == 0) {
                    bounds[0] = cp.association.getLeft().getMin();
                    bounds[2] = cp.association.getRight().getMin();
                } else {
                    bounds[0] = Utils.sign(cp.association.getLeft().getMin());
                    bounds[2] = Utils.sign(cp.association.getRight().getMin());
                }
                bounds[1] = this.maxMul(bounds[1], cp.association.getLeft().getMax());
                bounds[3] = this.maxMul(bounds[3], cp.association.getRight().getMax());
                this.prod *= cp.association.getRight().getMin();
            } else {
                if (i2 == 0) {
                    bounds[2] = bounds[2] * cp.association.getLeft().getMin();
                    bounds[0] = bounds[0] * cp.association.getRight().getMin();
                } else {
                    bounds[2] = bounds[2] * Utils.sign(cp.association.getLeft().getMin());
                    bounds[0] = bounds[0] * Utils.sign(cp.association.getRight().getMin());
                }
                bounds[3] = this.maxMul(bounds[3], cp.association.getLeft().getMax());
                bounds[1] = this.maxMul(bounds[1], cp.association.getRight().getMax());
                this.prod *= cp.association.getLeft().getMin();
            }
            ++i2;
        }
        return bounds;
    }

    public int[] computeBoundsUnique(ArrayList<ConstraintPart> parts) {
        int[] bounds = new int[4];
        int i = 1;
        while (i < 4) {
            bounds[i] = 1;
            ++i;
        }
        bounds[0] = 0;
        this.prod = 1;
        int i2 = 0;
        while (i2 < parts.size()) {
            ConstraintPart cp = parts.get(i2);
            if (!cp.inv) {
                bounds[2] = this.computeDelta(bounds[2], cp.association.getRight().getMin(), cp.association.getLeft().getMax());
                bounds[1] = this.maxMul(bounds[1], cp.association.getLeft().getMax());
                bounds[3] = this.maxMul(bounds[3], cp.association.getRight().getMax());
                this.prod *= cp.association.getRight().getMin();
            } else {
                bounds[2] = this.computeDelta(bounds[2], cp.association.getLeft().getMin(), cp.association.getRight().getMax());
                bounds[3] = this.maxMul(bounds[3], cp.association.getLeft().getMax());
                bounds[1] = this.maxMul(bounds[1], cp.association.getRight().getMax());
                this.prod *= cp.association.getLeft().getMin();
            }
            ++i2;
        }
        i2 = parts.size() - 1;
        while (i2 > 0) {
            ConstraintPart cp = parts.get(i2);
            bounds[0] = !cp.inv ? (i2 == parts.size() - 1 ? cp.association.getLeft().getMin() : this.computeDelta(bounds[0], cp.association.getLeft().getMin(), cp.association.getRight().getMax())) : (i2 == parts.size() - 1 ? cp.association.getRight().getMin() : this.computeDelta(bounds[0], cp.association.getRight().getMin(), cp.association.getLeft().getMax()));
            --i2;
        }
        return bounds;
    }

    public int computeUpperBound(ArrayList<ConstraintPart> parts, Association ass, int m, boolean backward) {
        int bnew = ass.getMaxRight();
        int g = 1;
        boolean star = false;
        for (ConstraintPart x : parts) {
            if (x.association.getId() != ass.getId() || x.inv == backward) continue;
            bnew = ass.getMaxLeft();
        }
        if (bnew == Environment.CARDINALITY_STAR) {
            bnew = Integer.MAX_VALUE;
            star = true;
        }
        int test = 0;
        do {
            g = 1;
            bnew = star ? (bnew /= 2) : --bnew;
            ++test;
            int i = 0;
            while (i < parts.size()) {
                ConstraintPart cp = backward ? parts.get(parts.size() - 1 - i) : parts.get(i);
                g = cp.association.getId() == ass.getId() ? (backward == cp.inv ? bnew + this.computeDelta(g - 1, cp.association.getMinRight(), cp.association.getMaxLeft()) : bnew + this.computeDelta(g - 1, cp.association.getMinLeft(), cp.association.getMaxRight())) : (backward == cp.inv ? this.computeDelta(g, cp.association.getMinRight(), cp.association.getMaxLeft()) : this.computeDelta(g, cp.association.getMinLeft(), cp.association.getMaxRight()));
                ++i;
            }
        } while (g > m);
        if (star) {
            bnew = this.finishUpperBound(bnew, parts, ass, m, backward);
        }
        return bnew;
    }

    public int finishUpperBound(int b, ArrayList<ConstraintPart> parts, Association ass, int m, boolean backward) {
        int bnew = b;
        int g = 1;
        do {
            g = 1;
            ++bnew;
            int i = 0;
            while (i < parts.size()) {
                ConstraintPart cp = backward ? parts.get(parts.size() - 1 - i) : parts.get(i);
                g = cp.association.getId() == ass.getId() ? (backward == cp.inv ? bnew + this.computeDelta(g - 1, cp.association.getMinRight(), cp.association.getMaxLeft()) : bnew + this.computeDelta(g - 1, cp.association.getMinLeft(), cp.association.getMaxRight())) : (backward == cp.inv ? this.computeDelta(g, cp.association.getMinRight(), cp.association.getMaxLeft()) : this.computeDelta(g, cp.association.getMinLeft(), cp.association.getMaxRight()));
                ++i;
            }
        } while (g <= m);
        return bnew - 1;
    }

    public int computeLowerBound(ArrayList<ConstraintPart> parts, Association ass, int m, boolean backward) {
        int bnew = ass.getMinRight();
        int f = 1;
        boolean begin = true;
        int maxRight = 0;
        int maxLeft = 0;
        for (ConstraintPart x : parts) {
            if (x.association.getId() != ass.getId() || x.inv == backward) continue;
            bnew = ass.getMinLeft();
        }
        do {
            f = 1;
            if (begin) {
                begin = false;
            } else {
                ++bnew;
            }
            int i = 0;
            while (i < parts.size()) {
                ConstraintPart cp = backward ? parts.get(parts.size() - 1 - i) : parts.get(i);
                maxRight = cp.association.getMaxRight() == Environment.CARDINALITY_STAR ? Integer.MAX_VALUE : cp.association.getMaxRight();
                maxLeft = cp.association.getMaxLeft() == Environment.CARDINALITY_STAR ? Integer.MAX_VALUE : cp.association.getMaxLeft();
                if (cp.association.getId() == ass.getId()) {
                    if (backward == cp.inv) {
                        System.out.println("ComputeDelta liefert: " + this.computeDelta(1, bnew, cp.association.getMaxLeft()));
                        f = maxRight == Integer.MAX_VALUE & f > 1 ? maxRight : maxRight * (f - 1) + this.computeDelta(1, bnew, maxLeft);
                    } else {
                        f = maxLeft == Integer.MAX_VALUE & f > 1 ? maxLeft : maxLeft * (f - 1) + this.computeDelta(1, bnew, maxRight);
                    }
                } else {
                    f = backward == cp.inv ? (maxRight == Integer.MAX_VALUE & f > 0 ? maxRight : maxRight * f) : (maxLeft == Integer.MAX_VALUE & f > 0 ? maxLeft : maxLeft * f);
                }
                ++i;
            }
        } while (f < m);
        return bnew;
    }

    public int computeDelta(int x, int b, int A) {
        if (x <= 0) {
            return 0;
        }
        return (int)Math.max(Math.ceil(b * x / A), (double)(b * 1));
    }

    public boolean match(ConstraintPart cp1, ConstraintPart cp2) {
        if (cp1.inv == cp2.inv) {
            if (cp1.inv) {
                return cp1.association.getLeft().assclass.getId() == cp2.association.getRight().assclass.getId();
            }
            return cp1.association.getRight().assclass.getId() == cp2.association.getLeft().assclass.getId();
        }
        if (cp1.inv) {
            return cp1.association.getLeft().assclass.getId() == cp2.association.getLeft().assclass.getId();
        }
        return cp1.association.getRight().assclass.getId() == cp2.association.getRight().assclass.getId();
    }

    public ArrayList<ConstraintPart> getLhs() {
        return this.lhs;
    }

    public ArrayList<ConstraintPart> getRhs() {
        return this.rhs;
    }

    public void clear() {
        this.lhs.clear();
        this.rhs.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public void addLhsPart(Association a, boolean inv) {
        this.lhs.add(new ConstraintPart(this, a, inv));
    }

    public void addRhsPart(Association a, boolean inv) {
        this.rhs.add(new ConstraintPart(this, a, inv));
    }

    public class ConstraintPart {
        public boolean inv;
        public Association association;
        public Constraint constraint;

        public ConstraintPart(Constraint c, Association a, boolean i) {
            this.constraint = c;
            this.association = a;
            this.inv = i;
        }
    }
}

