/*
 * Decompiled with CFR 0.152.
 */
package clews.data;

import clews.MainFrame;
import clews.data.Association;
import clews.data.AssociationAttribute;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.DataObject;
import clews.data.Instance;
import clews.data.Link;
import clews.data.Specification;
import clews.env.Graph;
import clews.env.Utils;
import clews.export.SpecificationILPExport;
import clews.gui.view.ConfigurationView;
import clews.gui.view.LinkView;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;

public class Configuration
extends DataObject<ConfigurationView> {
    protected String name;
    protected Specification specification;
    protected ArrayList<Instance> instances;
    protected ArrayList<Link> links;
    protected String path;

    public Configuration(Specification s) {
        this.specification = s;
        this.setName("Configuration" + this.id);
        this.instances = new ArrayList();
        this.links = new ArrayList();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public void delete(Instance in) {
        this.instances.remove(in);
    }

    public void delete(Link li) {
        li.left.removeLink(li, li.right, li.getView() != null ? ((LinkView)li.getView()).getRightCnt() : 0);
        li.right.removeLink(li, li.left, li.getView() != null ? ((LinkView)li.getView()).getLeftCnt() : 0);
        this.links.remove(li);
        this.applyChanges();
    }

    public void clear() {
        this.instances.clear();
        this.links.clear();
    }

    public void applyChanges() {
        for (Instance i : this.instances) {
            i.applyChanges();
        }
    }

    public Link link(ArrayList<Instance> ends) {
        if (ends.size() == 2) {
            return this.link(ends.get(0), ends.get(1));
        }
        return null;
    }

    public Link link(Instance i1, Instance i2) {
        Link l = new Link(this, i1, i2);
        i1.addLink(l, i2);
        i2.addLink(l, i1);
        this.links.add(l);
        i1.applyChanges();
        i2.applyChanges();
        return l;
    }

    public void addMinLinks(AssociationEnd a1, AssociationEnd a2) {
        ArrayList<Instance> i1 = new ArrayList<Instance>();
        ArrayList<Instance> i2 = new ArrayList<Instance>();
        Class c1 = a1.assclass;
        Class c2 = a2.assclass;
        for (Instance i : this.instances) {
            if (i.getType().getId() == c1.getId()) {
                i1.add(i);
            }
            if (i.getType().getId() != c2.getId()) continue;
            i2.add(i);
        }
        int cnt1 = i1.size();
        int cnt2 = i2.size();
        if (cnt1 > 0 && cnt2 > 0) {
            int ii1 = 0;
            int ii2 = 0;
            int lcm = Utils.lcm(cnt1, cnt2);
            int l = this.getNumberOfLinks(cnt1, a1, cnt2, a2);
            int i = 0;
            while (i < l) {
                ii1 = i % cnt1;
                ii2 = (i + i / lcm) % cnt2;
                Link tl = this.link((Instance)i1.get(ii1), (Instance)i2.get(ii2));
                if (this.view != null) {
                    ((ConfigurationView)this.view).addNewLinkView(tl);
                }
                ++i;
            }
        }
    }

    protected int getNumberOfLinks(int c1, AssociationEnd a1, int c2, AssociationEnd a2) {
        if (a2.type == AssociationAttribute.UNIQUE || a2.type == AssociationAttribute.NON_UNIQUE && a1.type == AssociationAttribute.ALL_SAME) {
            AssociationEnd tmpa = a1;
            a1 = a2;
            a2 = tmpa;
            int tmpc = c1;
            c1 = c2;
            c2 = tmpc;
        }
        if (a1.type == a2.type) {
            switch (a1.type) {
                case UNIQUE: {
                    return Math.max(c1 * a2.getMin(), c2 * a1.getMin());
                }
                case NON_UNIQUE: {
                    return Math.max(c1 * a2.getMin(), c2 * a1.getMin());
                }
                case ALL_SAME: {
                    return Math.min(c1, c2) * Math.max(a1.getMin(), a2.getMin());
                }
            }
        } else {
            if (a1.type == AssociationAttribute.UNIQUE && a2.type == AssociationAttribute.NON_UNIQUE) {
                return Math.max(c1 * a2.getMin(), c2 * a1.getMin());
            }
            if (a1.type == AssociationAttribute.UNIQUE && a2.type == AssociationAttribute.ALL_SAME) {
                return Math.max(c1 * a2.getMin(), c2 * a1.getMin());
            }
            if (a1.type == AssociationAttribute.NON_UNIQUE && a2.type == AssociationAttribute.ALL_SAME) {
                return Math.max(c1 * a2.getMin(), c2 * a1.getMin());
            }
        }
        return -1;
    }

    public Instance getInstanceById(int id) {
        for (Instance i : this.instances) {
            if (i.getId() != id) continue;
            return i;
        }
        return null;
    }

    public Instance addInstance(Class c) {
        int cnt = 1;
        for (Instance i : this.instances) {
            if (i.getType().getId() != c.getId()) continue;
            ++cnt;
        }
        Instance inst = new Instance(this, c);
        inst.setName(String.valueOf(c.getName()) + "(" + cnt + ")");
        this.instances.add(inst);
        inst.applyChanges();
        return inst;
    }

    public ArrayList<Instance> getInstances() {
        return this.instances;
    }

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public void setName(String n) {
        this.name = n;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void extendToInstance() {
        HashMap<Class, Integer> minObjects = new HashMap<Class, Integer>();
        for (Class c : this.getSpecification().getClasses()) {
            minObjects.put(c, 0);
        }
        for (Instance i : this.instances) {
            minObjects.put(i.getType(), minObjects.get(i.getType()) + 1);
        }
        SpecificationILPExport ilp = new SpecificationILPExport(this.getSpecification(), minObjects);
        ilp.export();
        if (ilp.solve() != null) {
            Dimension d = MainFrame.getInstance().getDiagramPanel().getSize();
            for (Class c : this.getSpecification().getClasses()) {
                int v = ilp.getResultVal(c) - minObjects.get(c);
                int k = 0;
                while (k < v) {
                    ((ConfigurationView)this.getView()).addDropInstance(c, new Point((int)(Math.random() * (double)d.width), (int)(Math.random() * (double)d.height)));
                    ++k;
                }
                minObjects.put(c, minObjects.get(c) + v);
            }
        }
        for (Association a : this.specification.getAssociations()) {
            ArrayList<Instance> l = this.getInstancesForType(a.getLeftClass());
            ArrayList<Instance> r = this.getInstancesForType(a.getRightClass());
            ArrayList<Link> ex = new ArrayList<Link>();
            for (Link ll : this.links) {
                if ((!l.contains(ll.left) || !r.contains(ll.right)) && (!r.contains(ll.left) || !l.contains(ll.right))) continue;
                ex.add(ll);
            }
            Graph g = new Graph();
            g.init(this.getNumberOfLinks(l.size(), a.getLeft(), r.size(), a.getRight()), l, r, ex);
            if (!g.findFeasible()) continue;
            for (Instance cl : l) {
                for (Instance cr : r) {
                    if (!g.isFlow(cl, cr)) continue;
                    ((ConfigurationView)this.getView()).addNewLinkView(this.link(cl, cr));
                }
            }
        }
    }

    protected ArrayList<Instance> getInstancesForType(Class c) {
        ArrayList<Instance> ret = new ArrayList<Instance>();
        for (Instance i : this.instances) {
            if (i.type != c) continue;
            ret.add(i);
        }
        return ret;
    }

    public boolean[][] findLinks(int l, int n, int m, boolean[][] fixed) {
        boolean[][] res = new boolean[n][m];
        int[] fleft = new int[n];
        int[] fright = new int[m];
        return res;
    }
}

