/*
 * Decompiled with CFR 0.152.
 */
package clews.data;

import clews.data.AssociationEnd;
import clews.data.DataObject;
import clews.data.Specification;
import clews.env.Environment;
import clews.gui.view.ClassView;
import java.util.ArrayList;

public class Class
extends DataObject<ClassView> {
    protected Specification spec;
    protected String name;
    protected int minobj;
    protected int weight;
    protected int maxobj;
    protected int minpartner;
    protected int maxpartner;
    protected int minmodelobj;
    protected boolean isConsistent = true;
    protected ArrayList<AssociationEnd> ends = new ArrayList();
    protected ArrayList<Integer> orPartner;
    protected String errorMessage;

    public Class(Specification s) {
        this(s, Environment.NO_CLASS_ID);
    }

    public Class(Specification s, int oid) {
        this.spec = s;
        if (oid != Environment.NO_CLASS_ID) {
            this.id = oid;
        }
        this.name = "Class" + this.id;
        this.weight = 1;
        this.maxobj = Environment.CARDINALITY_STAR;
        this.minpartner = 0;
        this.maxpartner = Environment.CARDINALITY_STAR;
        this.orPartner = new ArrayList();
    }

    public int getMaxObj() {
        return this.maxobj;
    }

    public void setMaxObj(int mo) {
        this.maxobj = mo;
    }

    public void setMinPartner(int mp) {
        if (mp >= 0) {
            this.minpartner = mp;
        }
    }

    public int getMinPartner() {
        return this.minpartner;
    }

    public void setMaxPartner(int mp) {
        this.maxpartner = mp;
        if (mp != Environment.CARDINALITY_STAR) {
            this.maxpartner = Math.max(this.getMinPartner(), mp);
        }
    }

    public int getMaxParnter() {
        return this.maxpartner;
    }

    public void setOrPartner(int classID) {
        this.orPartner.add(classID);
    }

    public ArrayList<Integer> getOrPartner() {
        return this.orPartner;
    }

    public void setWeight(int w) {
        this.weight = w;
    }

    public int getWeight() {
        return this.weight;
    }

    public void addAssociationEnd(AssociationEnd ae) {
        this.ends.add(ae);
    }

    public ArrayList<AssociationEnd> getEnds() {
        return this.ends;
    }

    public boolean isConsistent() {
        return this.isConsistent;
    }

    public void setIsConsistent(boolean val) {
        this.isConsistent = val;
    }

    public Specification getSpecification() {
        return this.spec;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public void setMinObj(int nr) {
        this.minobj = nr;
    }

    public void setMinModelObj(int nr) {
        this.minmodelobj = nr;
    }

    public int getMinObj() {
        return this.minobj;
    }

    public int getMinModelObj() {
        return this.minmodelobj;
    }

    public String toString() {
        return this.getName();
    }

    public void setErrorMessage(String mess) {
        this.errorMessage = mess;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

