/*
 * Decompiled with CFR 0.152.
 */
package clews.data;

import clews.data.AssociationAttribute;
import clews.data.AssociationEnd;
import clews.data.Class;
import clews.data.Constraint;
import clews.data.DataObject;
import clews.env.Environment;
import clews.gui.view.AssociationView;
import java.util.ArrayList;

public class Association
extends DataObject<AssociationView> {
    protected ArrayList<AssociationEnd> ends;
    protected ArrayList<Constraint.ConstraintPart> constraints;
    protected AssociationEnd left;
    protected AssociationEnd right;
    protected boolean isConsistent;
    protected String name;

    public Association(Class c1, Class c2) {
        this.isConsistent = true;
        this.constraints = new ArrayList();
        this.ends = new ArrayList();
        this.left = new AssociationEnd(this, AssociationAttribute.UNIQUE, 0, Environment.CARDINALITY_STAR, c1);
        this.ends.add(this.left);
        this.right = new AssociationEnd(this, AssociationAttribute.UNIQUE, 0, Environment.CARDINALITY_STAR, c2);
        this.ends.add(this.right);
        this.left.setOther(this.right);
        this.right.setOther(this.left);
        this.name = String.valueOf(this.left.assclass.toString().toLowerCase()) + "TO" + this.right.assclass.toString().toLowerCase();
        this.name = this.name.replace(" ", "");
        this.left.setConstrainedMax(Environment.CARDINALITY_STAR);
        this.left.setConstrainedMin(0);
        this.right.setConstrainedMax(Environment.CARDINALITY_STAR);
        this.right.setConstrainedMin(0);
    }

    public Association(ArrayList<AssociationEnd> ae) {
        this.ends = ae;
        this.constraints = new ArrayList();
        this.left = ae.get(0);
        this.right = ae.get(1);
        this.left.setOther(this.right);
        this.right.setOther(this.left);
        for (AssociationEnd e : this.ends) {
            e.assoc = this;
        }
    }

    public Association(Class c1, Class c2, AssociationView av) {
        this(c1, c2);
        this.setView(av);
    }

    public ArrayList<Constraint.ConstraintPart> getConstraints() {
        return this.constraints;
    }

    public void deleteConstraint(Constraint.ConstraintPart c) {
        this.constraints.remove(c);
    }

    public void addConstraint(Constraint.ConstraintPart c) {
        this.constraints.add(c);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isBinary() {
        return this.getArity() == 2;
    }

    public boolean isConsistent() {
        return this.isConsistent;
    }

    public void setIsConsistent(boolean val) {
        this.isConsistent = val;
    }

    public int getArity() {
        return this.ends == null ? 0 : this.ends.size();
    }

    public ArrayList<AssociationEnd> getEnds() {
        return this.ends;
    }

    public AssociationEnd getLeft() {
        return this.left;
    }

    public AssociationEnd getRight() {
        return this.right;
    }

    public Class getLeftClass() {
        return this.left.assclass;
    }

    public Class getRightClass() {
        return this.right.assclass;
    }

    public AssociationAttribute getTypeLeft() {
        return this.left.type;
    }

    public AssociationAttribute getTypeRight() {
        return this.right.type;
    }

    public int getMinLeft() {
        return this.left.getMin();
    }

    public int getMaxLeft() {
        return this.left.getMax();
    }

    public int getMinRight() {
        return this.right.getMin();
    }

    public int getMaxRight() {
        return this.right.getMax();
    }

    public int getConstrainedMaxLeftOld() {
        if (this.left.type != AssociationAttribute.UNIQUE) {
            return this.getMaxLeft();
        }
        int ret = this.getMaxLeft();
        if (ret == Environment.CARDINALITY_STAR) {
            ret = Integer.MAX_VALUE;
        }
        for (Constraint.ConstraintPart cp : this.constraints) {
            if (!cp.constraint.isActive()) continue;
            int cur = 0;
            if (!cp.inv) continue;
            if (this.right.getMax() == 20) {
                ret = 12;
                break;
            }
            if (this.left.getMin() != 0) {
                cur = cp.constraint.getLowerProduct(cp) / this.left.getMin();
            }
            if (cur > 0) {
                cur = (cp.constraint.getUpperBound() + cur - 1) / cur;
                ret = Math.min(ret, cur);
                continue;
            }
            ret = Math.min(ret, cp.constraint.getUpperBound());
        }
        if (ret == Integer.MAX_VALUE) {
            ret = Environment.CARDINALITY_STAR;
        }
        return ret;
    }

    public int getConstrainedMaxRightOld() {
        if (this.right.type != AssociationAttribute.UNIQUE) {
            return this.getMaxRight();
        }
        int ret = this.getMaxRight();
        if (ret == Environment.CARDINALITY_STAR) {
            ret = Integer.MAX_VALUE;
        }
        for (Constraint.ConstraintPart cp : this.constraints) {
            if (!cp.constraint.isActive()) continue;
            int cur = 0;
            if (cp.inv) continue;
            if (this.right.getMax() == 20) {
                ret = 12;
                break;
            }
            if (this.right.getMin() != 0) {
                cur = cp.constraint.getLowerProduct(cp) / this.right.getMin();
            }
            if (cur > 0) {
                cur = (cp.constraint.getUpperBound() + cur - 1) / cur;
                ret = Math.min(ret, cur);
                continue;
            }
            ret = Math.min(ret, cp.constraint.getUpperBound());
        }
        if (ret == Integer.MAX_VALUE) {
            ret = Environment.CARDINALITY_STAR;
        }
        return ret;
    }

    public int getConstrainedMinRight() {
        if (this.right.type != AssociationAttribute.UNIQUE) {
            return this.getMinRight();
        }
        if (this.getMinRight() == this.getMaxRight()) {
            return this.getMinRight();
        }
        int ret = this.getMinRight();
        for (Constraint.ConstraintPart cp : this.constraints) {
            if (!cp.constraint.isActive()) continue;
            boolean found = false;
            int[] bounds = cp.constraint.getStrongestBounds();
            int m = bounds[2];
            for (Constraint.ConstraintPart cp1 : cp.constraint.lhs) {
                if (this.getId() != cp1.association.getId()) continue;
                if (!cp.inv) {
                    if (cp.constraint.getIncreaseLowerLhs()) {
                        ret = cp.constraint.computeLowerBound(cp.constraint.lhs, this, m, false);
                    }
                } else if (cp.constraint.getIncreaseLowerLhsBack()) {
                    ret = cp.constraint.computeLowerBound(cp.constraint.lhs, this, m, true);
                }
                found = true;
                break;
            }
            if (found) continue;
            if (!cp.inv) {
                if (!cp.constraint.getIncreaseLowerRhs()) continue;
                ret = cp.constraint.computeLowerBound(cp.constraint.rhs, this, m, false);
                continue;
            }
            if (!cp.constraint.getIncreaseLowerRhsBack()) continue;
            ret = cp.constraint.computeLowerBound(cp.constraint.rhs, this, m, true);
        }
        return ret;
    }

    public int getConstrainedMinLeft() {
        if (this.left.type != AssociationAttribute.UNIQUE) {
            return this.getMinLeft();
        }
        if (this.getMinLeft() == this.getMaxLeft()) {
            return this.getMinLeft();
        }
        int ret = this.getMinLeft();
        block0: for (Constraint.ConstraintPart cp : this.constraints) {
            if (!cp.constraint.isActive()) continue;
            boolean found = false;
            int[] bounds = cp.constraint.getStrongestBounds();
            int m = bounds[0];
            for (Constraint.ConstraintPart cp1 : cp.constraint.lhs) {
                if (this.getId() == cp1.association.getId()) {
                    if (!cp.inv) {
                        if (cp.constraint.getIncreaseLowerLhsBack()) {
                            ret = cp.constraint.computeLowerBound(cp.constraint.lhs, this, m, true);
                        }
                    } else if (cp.constraint.getIncreaseLowerLhs()) {
                        ret = cp.constraint.computeLowerBound(cp.constraint.lhs, this, m, false);
                    }
                    found = true;
                    continue block0;
                }
                if (found) continue;
                if (!cp.inv) {
                    if (!cp.constraint.getIncreaseLowerRhsBack()) continue;
                    ret = cp.constraint.computeLowerBound(cp.constraint.rhs, this, m, true);
                    continue;
                }
                if (!cp.constraint.getIncreaseLowerRhs()) continue;
                ret = cp.constraint.computeLowerBound(cp.constraint.rhs, this, m, false);
            }
        }
        return ret;
    }

    public int getConstrainedMaxRight() {
        if (this.right.type != AssociationAttribute.UNIQUE) {
            return this.getMaxRight();
        }
        int ret = this.getMaxRight();
        if (ret == Environment.CARDINALITY_STAR) {
            ret = Integer.MAX_VALUE;
        }
        if (ret <= 1) {
            return ret;
        }
        for (Constraint.ConstraintPart cp : this.constraints) {
            if (!cp.constraint.isActive()) continue;
            boolean found = false;
            int[] bounds = cp.constraint.getStrongestBounds();
            int m = bounds[3];
            if (m == Environment.CARDINALITY_STAR || m == Integer.MAX_VALUE) {
                return this.getMaxRight();
            }
            for (Constraint.ConstraintPart cp1 : cp.constraint.lhs) {
                if (this.getId() != cp1.association.getId()) continue;
                if (!cp.inv) {
                    if (cp.constraint.getReduceUpperLhs()) {
                        ret = cp.constraint.computeUpperBound(cp.constraint.lhs, this, m, false);
                    }
                } else if (cp.constraint.getReduceUpperLhsBack()) {
                    ret = cp.constraint.computeUpperBound(cp.constraint.lhs, this, m, true);
                }
                found = true;
                break;
            }
            if (found) continue;
            if (!cp.inv) {
                if (!cp.constraint.getReduceUpperRhs()) continue;
                ret = cp.constraint.computeUpperBound(cp.constraint.rhs, this, m, false);
                continue;
            }
            if (!cp.constraint.getReduceUpperRhsBack()) continue;
            ret = cp.constraint.computeUpperBound(cp.constraint.rhs, this, m, true);
        }
        if (ret == Integer.MAX_VALUE) {
            ret = Environment.CARDINALITY_STAR;
        }
        return ret;
    }

    public int getConstrainedMaxLeft() {
        if (this.left.type != AssociationAttribute.UNIQUE) {
            return this.getMaxLeft();
        }
        int ret = this.getMaxLeft();
        if (ret == Environment.CARDINALITY_STAR) {
            ret = Integer.MAX_VALUE;
        }
        if (ret <= 1) {
            return ret;
        }
        for (Constraint.ConstraintPart cp : this.constraints) {
            if (!cp.constraint.isActive()) continue;
            boolean found = false;
            int[] bounds = cp.constraint.getStrongestBounds();
            int m = bounds[1];
            if (m == Environment.CARDINALITY_STAR || m == Integer.MAX_VALUE) {
                return this.getMaxLeft();
            }
            for (Constraint.ConstraintPart cp1 : cp.constraint.lhs) {
                if (this.getId() != cp1.association.getId()) continue;
                if (!cp.inv) {
                    if (cp.constraint.getReduceUpperLhs()) {
                        ret = cp.constraint.computeUpperBound(cp.constraint.lhs, this, m, true);
                    }
                } else if (cp.constraint.getReduceUpperLhsBack()) {
                    ret = cp.constraint.computeUpperBound(cp.constraint.lhs, this, m, false);
                }
                found = true;
                break;
            }
            if (found) continue;
            if (!cp.inv) {
                if (!cp.constraint.getReduceUpperRhsBack()) continue;
                ret = cp.constraint.computeUpperBound(cp.constraint.rhs, this, m, true);
                continue;
            }
            if (!cp.constraint.getReduceUpperRhs()) continue;
            ret = cp.constraint.computeUpperBound(cp.constraint.rhs, this, m, false);
        }
        if (ret == Integer.MAX_VALUE) {
            ret = Environment.CARDINALITY_STAR;
        }
        return ret;
    }

    public void setCards(int mil, int mal, int mir, int mar) {
        this.left.setMinMax(mil, mal);
        this.right.setMinMax(mir, mar);
    }

    public void setTypes(AssociationAttribute l, AssociationAttribute r) {
        this.left.type = l;
        this.right.type = r;
    }

    public String toString() {
        return this.getName();
    }
}

