/*
 * Decompiled with CFR 0.152.
 */
package clews;

import clews.Domain;
import clews.env.Environment;
import clews.gui.DomainTree;
import clews.gui.MainKeyListener;
import clews.gui.MainMenu;
import clews.gui.diagram.DiagramPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -4520788081029975623L;
    protected static MainFrame instance = null;
    protected DomainTree domainTree;
    protected JTextArea textOutput;
    protected DiagramPanel diagramPanel;
    protected JLabel messageText;
    protected MainMenu mainMenu;
    protected Domain domain;

    protected MainFrame() {
        super("clews");
    }

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    public DomainTree getDomainTree() {
        return this.domainTree;
    }

    public JTextArea getTextOutput() {
        return this.textOutput;
    }

    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel;
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void update() {
        this.setMessageText(" ");
        this.domainTree.updateUI();
        this.diagramPanel.repaint();
    }

    public void setMessageText(String text) {
        this.messageText.setText(text);
        this.messageText.updateUI();
    }

    public void startUp() {
        this.addListener();
        this.setUpLayout();
        this.domain = new Domain(this);
        this.domain.init();
    }

    protected void addListener() {
        this.addKeyListener(new MainKeyListener(this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.clearHistory();
                System.exit(0);
            }
        });
    }

    public static boolean clearHistory() {
        File f = new File(Environment.HISTORY_PATH);
        if (!f.exists() && !f.mkdir()) {
            return false;
        }
        File[] files = f.listFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
        return true;
    }

    protected void setUpLayout() {
        this.setUpLayout(true);
    }

    protected void setUpLayout(boolean show) {
        if (show) {
            this.setLocation(32, 32);
            this.setSize(new Dimension(1024, 768));
            this.setExtendedState(this.getExtendedState() | 6);
            this.setVisible(true);
            this.setVisible(false);
        }
        JPanel contentPane = new JPanel(new BorderLayout());
        JPanel left = new JPanel();
        left.setLayout(new BorderLayout());
        this.domainTree = new DomainTree(this);
        JScrollPane leftscroll = new JScrollPane(this.domainTree);
        left.add(leftscroll);
        this.diagramPanel = new DiagramPanel(this);
        JPanel lower = new JPanel();
        JPanel upper = new JPanel();
        JSplitPane right = new JSplitPane(0, upper, lower);
        JSplitPane pane = new JSplitPane(1, left, right);
        upper.setLayout(new BorderLayout());
        JScrollPane upperScroll = new JScrollPane(this.diagramPanel);
        upperScroll.setVerticalScrollBarPolicy(22);
        upper.add(upperScroll);
        lower.setLayout(new BorderLayout());
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        JScrollPane scroll = new JScrollPane(ta);
        lower.add(scroll);
        this.textOutput = ta;
        contentPane.add(pane);
        this.messageText = new JLabel(" ");
        contentPane.add((Component)this.messageText, "South");
        this.mainMenu = new MainMenu(this);
        this.setJMenuBar(this.mainMenu);
        contentPane.setOpaque(true);
        this.setContentPane(contentPane);
        this.setExtendedState(this.getExtendedState() | 6);
        if (show) {
            this.setVisible(true);
        }
        right.setDividerLocation(0.85);
        pane.setDividerLocation(0.15);
        pane.repaint();
        this.domainTree.updateUI();
        this.mainMenu.updateUI();
        this.messageText.repaint();
        this.update();
    }
}

