/*
 * Decompiled with CFR 0.152.
 */
package clews;

import clews.MainFrame;
import clews.env.Environment;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.sf.javailp.Linear;
import net.sf.javailp.Problem;
import net.sf.javailp.Solver;
import net.sf.javailp.SolverFactoryLpSolve;

public class Main {
    public static void doInit() {
        Environment.getStandardText("init");
        if (!MainFrame.clearHistory()) {
            System.out.println("Error during startup. Cannot create temporary directory");
        }
    }

    public static void main(String[] args) {
        Main.doInit();
        MainFrame cmf = MainFrame.getInstance();
        Main.checkILPSolver();
        cmf.startUp();
    }

    public static void checkILPSolver() {
        try {
            SolverFactoryLpSolve factory = new SolverFactoryLpSolve();
            factory.setParameter((Object)1, (Object)0);
            factory.setParameter((Object)0, (Object)100);
            Solver solver = factory.get();
            Problem p = new Problem();
            Linear l = new Linear();
            l.add((Number)1, (Object)"x");
            p.add(l, "<=", (Number)12);
            solver.solve(p);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "No ILP-Solver found! Clews will not work properly.");
        }
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
    }
}

