/*
 * Decompiled with CFR 0.152.
 */
package clews;

import clews.Domain;
import clews.MainFrame;
import clews.env.Environment;
import clews.export.DomainXMLExport;
import clews.export.DomainXMLImport;
import clews.gui.view.ClassView;
import java.io.File;
import java.util.Stack;

public class History {
    protected Stack<HistoryObject> undoStack;
    protected Stack<HistoryObject> redoStack;
    protected MainFrame mainFrame;

    public History(MainFrame mf) {
        this.mainFrame = mf;
    }

    public void doUndo() {
        try {
            HistoryObject ho = this.undoStack.peek();
            File f = File.createTempFile("redo", "." + Environment.DOMAIN_ENDING, new File(Environment.HISTORY_PATH));
            f.deleteOnExit();
            DomainXMLExport dxe = new DomainXMLExport(MainFrame.getInstance().getDomain());
            dxe.saveToDisk(f.getAbsolutePath(), true);
            switch (ho.operation) {
                case ADD: {
                    if (!(ho.object instanceof ClassView)) break;
                    this.undoAddClass((ClassView)ho.object);
                    break;
                }
                case CHANGE: {
                    break;
                }
                case DELETE: {
                    if (!(ho.object instanceof ClassView)) break;
                    this.undoDeleteClass((ClassView)ho.object);
                }
            }
            DomainXMLImport dxi = new DomainXMLImport();
            dxi.loadFromDisk(ho.file.getAbsolutePath());
            this.redoStack.push(this.undoStack.pop());
            this.redoStack.peek().file = f;
            this.mainFrame.getMainMenu().refreshUnRedo();
            Domain d = this.mainFrame.getDomain();
            String old = d.getPath();
            d.newDomain(false);
            d.setPath(old);
            d.setConfigurations(dxi.getConfigurations());
            d.setSpecification(dxi.getSpecification());
            d.setActiveDiagram(dxi.getActive());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void undoAddClass(ClassView cv) {
    }

    public void undoDeleteClass(ClassView cv) {
    }

    public void doRedo() {
        try {
            HistoryObject ho = this.redoStack.peek();
            this.undoStack.push(this.redoStack.pop());
            this.mainFrame.getMainMenu().refreshUnRedo();
            File f = File.createTempFile("undo", "." + Environment.DOMAIN_ENDING, new File(Environment.HISTORY_PATH));
            f.deleteOnExit();
            DomainXMLExport dxe = new DomainXMLExport(MainFrame.getInstance().getDomain());
            dxe.saveToDisk(f.getAbsolutePath(), true);
            DomainXMLImport dxi = new DomainXMLImport();
            dxi.loadFromDisk(ho.file.getAbsolutePath());
            this.undoStack.peek().file = f;
            Domain d = this.mainFrame.getDomain();
            String old = d.getPath();
            d.newDomain(false);
            d.setPath(old);
            d.setConfigurations(dxi.getConfigurations());
            d.setSpecification(dxi.getSpecification());
            d.setActiveDiagram(dxi.getActive());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Stack<HistoryObject> getUndoStack() {
        return this.undoStack;
    }

    public Stack<HistoryObject> getRedoStack() {
        return this.redoStack;
    }

    public void clearUndoRedo() {
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        if (this.mainFrame.getMainMenu() != null) {
            this.mainFrame.getMainMenu().refreshUnRedo();
        }
    }

    public void addUndo(Object obj, Operation op, String msg) {
        try {
            File f = File.createTempFile("undo", "." + Environment.DOMAIN_ENDING, new File(Environment.HISTORY_PATH));
            f.deleteOnExit();
            this.undoStack.push(new HistoryObject(obj, op, msg, f));
            this.redoStack = new Stack();
            this.mainFrame.setMessageText(String.valueOf(msg) + "...");
            this.mainFrame.getMainMenu().refreshUnRedo();
            DomainXMLExport dxe = new DomainXMLExport(MainFrame.getInstance().getDomain());
            dxe.saveToDisk(f.getAbsolutePath(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class HistoryObject {
        protected Object object;
        protected Operation operation;
        protected String message;
        protected File file;

        public HistoryObject(Object obj, Operation op, String msg, File f) {
            this.object = obj;
            this.operation = op;
            this.message = msg;
            this.file = f;
            if (!this.message.startsWith("'")) {
                this.message = "'" + this.message;
            }
            if (!this.message.endsWith("'")) {
                this.message = String.valueOf(this.message) + "'";
            }
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum Operation {
        ADD,
        DELETE,
        CHANGE;

    }
}

