/*
 * Decompiled with CFR 0.152.
 */
package clews;

import clews.History;
import clews.MainFrame;
import clews.data.Class;
import clews.data.Configuration;
import clews.data.Constraint;
import clews.data.DataObject;
import clews.data.Specification;
import clews.gui.DomainTree;
import clews.gui.DomainTreeModel;
import clews.gui.diagram.ConfigurationDiagram;
import clews.gui.diagram.DiagramPanel;
import clews.gui.diagram.SpecificationDiagram;
import clews.gui.view.ClassView;
import clews.gui.view.ConfigurationView;
import clews.gui.view.ConstraintView;
import clews.gui.view.SpecificationView;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class Domain {
    protected Specification specification;
    protected ArrayList<Configuration> configurations;
    protected MainFrame mainFrame;
    protected DomainTree domainTree;
    protected JTextArea textOutput;
    protected DiagramPanel diagramPanel;
    protected String path;
    protected History history;

    public Domain() {
        this(null);
        this.init();
    }

    public Domain(MainFrame mf) {
        this.mainFrame = mf;
        if (this.mainFrame != null) {
            this.history = new History(this.mainFrame);
            this.history.clearUndoRedo();
        }
    }

    public void init() {
        this.path = null;
        if (this.mainFrame != null) {
            this.domainTree = this.mainFrame.getDomainTree();
            this.textOutput = this.mainFrame.getTextOutput();
            this.diagramPanel = this.mainFrame.getDiagramPanel();
        }
        this.newDomain();
    }

    public void setPath(String p) {
        this.path = p;
    }

    public String getPath() {
        return this.path;
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public ArrayList<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(ArrayList<Configuration> configs) {
        this.configurations = configs;
    }

    public History getHistory() {
        return this.history;
    }

    public Configuration addNewConfiguration() {
        if (this.history != null) {
            this.history.addUndo(null, History.Operation.ADD, "New Configuration added");
        }
        Configuration c = this.addNewConfiguration(null);
        return c;
    }

    public Constraint addNewConstraint() {
        if (this.history != null) {
            this.history.addUndo(null, History.Operation.ADD, "New Constraint added");
        }
        Constraint c = this.specification.addNewConstraint();
        ConstraintView cv = new ConstraintView(c);
        c.setView(cv);
        if (this.domainTree != null) {
            this.domainTree.updateUI();
        }
        cv.edit();
        return c;
    }

    protected Configuration addNewConfiguration(Configuration exc) {
        Configuration c = exc == null ? new Configuration(this.specification) : exc;
        ConfigurationView cv = new ConfigurationView(c);
        c.setView(cv);
        this.configurations.add(c);
        if (this.mainFrame != null) {
            this.mainFrame.getDiagramPanel().changeSelectedDiagram(cv.getDiagram());
            this.mainFrame.update();
        }
        return cv.getConfiguration();
    }

    public void addNewMinimalConfiguration() {
        if (this.specification.isConsistent()) {
            this.specification.createMinimalConfiguration();
        } else if (this.mainFrame != null) {
            JOptionPane.showConfirmDialog(this.mainFrame, "Cannot create configuration since the specification is not consistent", "Creation not possible...", 1);
        }
    }

    public Class addNewClass() {
        if (this.history != null) {
            this.history.addUndo(null, History.Operation.ADD, "New Class added");
        }
        Class c = this.specification.addNewClass();
        if (this.mainFrame != null) {
            ClassView cv = ((SpecificationView)this.specification.getView()).addNewClassView(c);
            this.mainFrame.getDomainTree().updateUI();
        }
        return c;
    }

    public void newDomain() {
        this.newDomain(true);
    }

    public void newDomain(boolean reset) {
        if (reset) {
            DataObject.resetIds();
        }
        this.specification = new Specification();
        this.configurations = new ArrayList();
        if (this.mainFrame != null) {
            SpecificationView sv = new SpecificationView(this.specification);
            this.specification.setView(sv);
            if (this.mainFrame.getDiagramPanel() != null) {
                this.mainFrame.getDiagramPanel().resetView();
            }
        }
        this.setSpecification(this.specification);
    }

    public void setActiveDiagram(String active) {
        if (this.diagramPanel != null) {
            if (((SpecificationView)this.specification.getView()).getDiagram().getName().equals(active)) {
                this.diagramPanel.changeSelectedDiagram(((SpecificationView)this.specification.getView()).getDiagram());
            }
            for (Configuration c : this.configurations) {
                if (!((ConfigurationView)c.getView()).getDiagram().getName().equals(active)) continue;
                this.diagramPanel.changeSelectedDiagram(((ConfigurationView)c.getView()).getDiagram());
            }
        }
    }

    public void classDroped(Class c, Point p) {
        if (this.diagramPanel != null) {
            Point tp = new Point();
            this.diagramPanel.getDiagram().getInverseTransform().transform(p, tp);
            if (this.diagramPanel.getDiagram() instanceof ConfigurationDiagram && c != null) {
                this.history.addUndo(null, History.Operation.ADD, "New Instance added");
                ((ConfigurationDiagram)this.diagramPanel.getDiagram()).getConfigurationView().addDropInstance(c, tp);
            }
            if (this.diagramPanel.getDiagram() instanceof SpecificationDiagram) {
                ((ClassView)this.addNewClass().getView()).setPosFromPosition(tp);
            }
            this.diagramPanel.repaint();
        }
    }

    public void setSpecification(Specification spec) {
        this.specification = spec;
        for (Constraint c : this.specification.getConstraints()) {
            c.computeResultingInterval();
        }
        if (this.diagramPanel != null) {
            this.diagramPanel.changeSelectedDiagram(((SpecificationView)spec.getView()).getDiagram());
        }
        if (this.mainFrame != null) {
            System.out.println(this.domainTree);
            this.domainTree.setModel(new DomainTreeModel(this));
            int i = 0;
            while (i < this.domainTree.getRowCount()) {
                this.domainTree.expandRow(i);
                ++i;
            }
            this.mainFrame.repaint();
        }
    }

    public void extendConfiguration() {
        if (this.diagramPanel != null && this.diagramPanel.getDiagram() instanceof ConfigurationDiagram) {
            Configuration c = ((ConfigurationDiagram)this.diagramPanel.getDiagram()).getConfigurationView().getConfiguration();
            c.extendToInstance();
        }
    }
}

